/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.ser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.afterburner.ser.BeanPropertyAccessor;
import tools.jackson.module.afterburner.ser.BooleanFieldPropertyWriter;
import tools.jackson.module.afterburner.ser.BooleanMethodPropertyWriter;
import tools.jackson.module.afterburner.ser.IntFieldPropertyWriter;
import tools.jackson.module.afterburner.ser.IntMethodPropertyWriter;
import tools.jackson.module.afterburner.ser.LongFieldPropertyWriter;
import tools.jackson.module.afterburner.ser.LongMethodPropertyWriter;
import tools.jackson.module.afterburner.ser.ObjectFieldPropertyWriter;
import tools.jackson.module.afterburner.ser.ObjectMethodPropertyWriter;
import tools.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import tools.jackson.module.afterburner.ser.StringFieldPropertyWriter;
import tools.jackson.module.afterburner.ser.StringMethodPropertyWriter;
import tools.jackson.module.afterburner.util.ClassName;
import tools.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import tools.jackson.module.afterburner.util.MyClassLoader;
import tools.jackson.module.afterburner.util.bytebuddy.AbstractCreateLocalVarStackManipulation;
import tools.jackson.module.afterburner.util.bytebuddy.AbstractDelegatingAppender;
import tools.jackson.module.afterburner.util.bytebuddy.AbstractPropertyStackManipulation;
import tools.jackson.module.afterburner.util.bytebuddy.SinglePropStackManipulationSupplier;
import tools.jackson.module.afterburner.util.bytebuddy.UsingIfStackManipulation;
import tools.jackson.module.afterburner.util.bytebuddy.UsingSwitchStackManipulation;

public class PropertyAccessorCollector
extends DynamicPropertyAccessorBase {
    private final List<BooleanMethodPropertyWriter> _booleanGetters = new LinkedList<BooleanMethodPropertyWriter>();
    private final List<IntMethodPropertyWriter> _intGetters = new LinkedList<IntMethodPropertyWriter>();
    private final List<LongMethodPropertyWriter> _longGetters = new LinkedList<LongMethodPropertyWriter>();
    private final List<StringMethodPropertyWriter> _stringGetters = new LinkedList<StringMethodPropertyWriter>();
    private final List<ObjectMethodPropertyWriter> _objectGetters = new LinkedList<ObjectMethodPropertyWriter>();
    private final List<BooleanFieldPropertyWriter> _booleanFields = new LinkedList<BooleanFieldPropertyWriter>();
    private final List<IntFieldPropertyWriter> _intFields = new LinkedList<IntFieldPropertyWriter>();
    private final List<LongFieldPropertyWriter> _longFields = new LinkedList<LongFieldPropertyWriter>();
    private final List<StringFieldPropertyWriter> _stringFields = new LinkedList<StringFieldPropertyWriter>();
    private final List<ObjectFieldPropertyWriter> _objectFields = new LinkedList<ObjectFieldPropertyWriter>();
    private final Class<?> beanClass;
    private final TypeDescription beanClassDefinition;

    public PropertyAccessorCollector(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanClassDefinition = new TypeDescription.ForLoadedType(beanClass);
    }

    public BooleanMethodPropertyWriter addBooleanGetter(BeanPropertyWriter bpw) {
        return this._add(this._booleanGetters, new BooleanMethodPropertyWriter(bpw, null, this._booleanGetters.size(), null));
    }

    public IntMethodPropertyWriter addIntGetter(BeanPropertyWriter bpw) {
        return this._add(this._intGetters, new IntMethodPropertyWriter(bpw, null, this._intGetters.size(), null));
    }

    public LongMethodPropertyWriter addLongGetter(BeanPropertyWriter bpw) {
        return this._add(this._longGetters, new LongMethodPropertyWriter(bpw, null, this._longGetters.size(), null));
    }

    public StringMethodPropertyWriter addStringGetter(BeanPropertyWriter bpw) {
        return this._add(this._stringGetters, new StringMethodPropertyWriter(bpw, null, this._stringGetters.size(), null));
    }

    public ObjectMethodPropertyWriter addObjectGetter(BeanPropertyWriter bpw) {
        return this._add(this._objectGetters, new ObjectMethodPropertyWriter(bpw, null, this._objectGetters.size(), null));
    }

    public BooleanFieldPropertyWriter addBooleanField(BeanPropertyWriter bpw) {
        return this._add(this._booleanFields, new BooleanFieldPropertyWriter(bpw, null, this._booleanFields.size(), null));
    }

    public IntFieldPropertyWriter addIntField(BeanPropertyWriter bpw) {
        return this._add(this._intFields, new IntFieldPropertyWriter(bpw, null, this._intFields.size(), null));
    }

    public LongFieldPropertyWriter addLongField(BeanPropertyWriter bpw) {
        return this._add(this._longFields, new LongFieldPropertyWriter(bpw, null, this._longFields.size(), null));
    }

    public StringFieldPropertyWriter addStringField(BeanPropertyWriter bpw) {
        return this._add(this._stringFields, new StringFieldPropertyWriter(bpw, null, this._stringFields.size(), null));
    }

    public ObjectFieldPropertyWriter addObjectField(BeanPropertyWriter bpw) {
        return this._add(this._objectFields, new ObjectFieldPropertyWriter(bpw, null, this._objectFields.size(), null));
    }

    public BeanPropertyAccessor findAccessor(MyClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = new MyClassLoader(this.beanClass.getClassLoader(), true);
        }
        ClassName baseName = ClassName.constructFor(this.beanClass, "$Access4JacksonSerializer");
        Class<?> accessorClass = this.generateAccessorClass(classLoader, baseName);
        try {
            return (BeanPropertyAccessor)accessorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + accessorClass.getName() + "': " + e.getMessage(), e);
        }
    }

    public Class<?> generateAccessorClass(MyClassLoader classLoader, ClassName baseName) {
        DynamicType.Builder<?> builder = new ByteBuddy(ClassFileVersion.JAVA_V6).with(TypeValidation.DISABLED).subclass(BeanPropertyAccessor.class, (ConstructorStrategy)ConstructorStrategy.Default.DEFAULT_CONSTRUCTOR).name(baseName.getSlashedTemplate()).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, TypeManifestation.FINAL});
        if (!this._intFields.isEmpty()) {
            builder = this._addFields(builder, this._intFields, "intField", MethodReturn.INTEGER);
        }
        if (!this._longFields.isEmpty()) {
            builder = this._addFields(builder, this._longFields, "longField", MethodReturn.LONG);
        }
        if (!this._stringFields.isEmpty()) {
            builder = this._addFields(builder, this._stringFields, "stringField", MethodReturn.REFERENCE);
        }
        if (!this._objectFields.isEmpty()) {
            builder = this._addFields(builder, this._objectFields, "objectField", MethodReturn.REFERENCE);
        }
        if (!this._booleanFields.isEmpty()) {
            builder = this._addFields(builder, this._booleanFields, "booleanField", MethodReturn.INTEGER);
        }
        if (!this._intGetters.isEmpty()) {
            builder = this._addGetters(builder, this._intGetters, "intGetter", MethodReturn.INTEGER);
        }
        if (!this._longGetters.isEmpty()) {
            builder = this._addGetters(builder, this._longGetters, "longGetter", MethodReturn.LONG);
        }
        if (!this._stringGetters.isEmpty()) {
            builder = this._addGetters(builder, this._stringGetters, "stringGetter", MethodReturn.REFERENCE);
        }
        if (!this._objectGetters.isEmpty()) {
            builder = this._addGetters(builder, this._objectGetters, "objectGetter", MethodReturn.REFERENCE);
        }
        if (!this._booleanGetters.isEmpty()) {
            builder = this._addGetters(builder, this._booleanGetters, "booleanGetter", MethodReturn.INTEGER);
        }
        byte[] bytecode = builder.make().getBytes();
        baseName.assignChecksum(bytecode);
        try {
            return classLoader.loadClass(baseName.getDottedName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return classLoader.loadAndResolve(baseName, bytecode);
        }
    }

    private <T extends OptimizedBeanPropertyWriter<T>> DynamicType.Builder<?> _addGetters(DynamicType.Builder<?> builder, List<T> props, String methodName, MethodReturn methodReturn) {
        return builder.method((ElementMatcher)ElementMatchers.named((String)methodName)).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new MethodAppender<T>(this.beanClassDefinition, props, methodReturn)}));
    }

    private <T extends OptimizedBeanPropertyWriter<T>> DynamicType.Builder<?> _addFields(DynamicType.Builder<?> builder, List<T> props, String methodName, MethodReturn methodReturn) {
        return builder.method((ElementMatcher)ElementMatchers.named((String)methodName)).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new FieldAppender<T>(this.beanClassDefinition, props, methodReturn)}));
    }

    private static class MethodAppender<T extends OptimizedBeanPropertyWriter<T>>
    extends AbstractDelegatingAppender<T> {
        final TypeDescription beanClassDescription;
        final List<T> props;
        final MethodReturn methodReturn;

        MethodAppender(TypeDescription beanClassDescription, List<T> props, MethodReturn methodReturn) {
            super(props);
            this.beanClassDescription = beanClassDescription;
            this.props = props;
            this.methodReturn = methodReturn;
        }

        @Override
        protected StackManipulation usingSwitch() {
            return new UsingSwitchStackManipulation<T>(LocalVarIndexCalculator.INSTANCE, this.props, SingleMethodStackManipulationSupplier.of(this.beanClassDescription, this.methodReturn), false);
        }

        @Override
        protected StackManipulation createLocalVar() {
            return CreateLocalVarStackManipulation.of(this.beanClassDescription);
        }

        @Override
        protected StackManipulation usingIf() {
            return new UsingIfStackManipulation<T>(LocalVarIndexCalculator.INSTANCE, this.props, SingleMethodStackManipulationSupplier.of(this.beanClassDescription, this.methodReturn), false);
        }

        @Override
        protected StackManipulation single() {
            return new SingleMethodStackManipulation<OptimizedBeanPropertyWriter>(this.beanClassDescription, (OptimizedBeanPropertyWriter)((Object)this.props.get(0)), this.methodReturn);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodAppender that = (MethodAppender)o;
            if (!this.beanClassDescription.equals(that.beanClassDescription)) {
                return false;
            }
            if (!this.props.equals(that.props)) {
                return false;
            }
            return this.methodReturn == that.methodReturn;
        }

        public int hashCode() {
            int result = this.beanClassDescription.hashCode();
            result = 31 * result + this.props.hashCode();
            result = 31 * result + this.methodReturn.hashCode();
            return result;
        }
    }

    private static class FieldAppender<T extends OptimizedBeanPropertyWriter<T>>
    extends AbstractDelegatingAppender<T> {
        private final TypeDescription beanClassDescription;
        private final List<T> props;
        private final MethodReturn methodReturn;

        FieldAppender(TypeDescription beanClassDescription, List<T> props, MethodReturn methodReturn) {
            super(props);
            this.beanClassDescription = beanClassDescription;
            this.props = props;
            this.methodReturn = methodReturn;
        }

        @Override
        protected StackManipulation usingSwitch() {
            return new UsingSwitchStackManipulation<T>(LocalVarIndexCalculator.INSTANCE, this.props, SingleFieldStackManipulationSupplier.of(this.beanClassDescription, this.methodReturn), false);
        }

        @Override
        protected StackManipulation createLocalVar() {
            return CreateLocalVarStackManipulation.of(this.beanClassDescription);
        }

        @Override
        protected StackManipulation usingIf() {
            return new UsingIfStackManipulation<T>(LocalVarIndexCalculator.INSTANCE, this.props, SingleFieldStackManipulationSupplier.of(this.beanClassDescription, this.methodReturn), false);
        }

        @Override
        protected StackManipulation single() {
            return new SingleFieldStackManipulation<OptimizedBeanPropertyWriter>(this.beanClassDescription, (OptimizedBeanPropertyWriter)((Object)this.props.get(0)), this.methodReturn);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodAppender that = (MethodAppender)o;
            if (!this.beanClassDescription.equals(that.beanClassDescription)) {
                return false;
            }
            if (!this.props.equals(that.props)) {
                return false;
            }
            return this.methodReturn == that.methodReturn;
        }

        public int hashCode() {
            int result = this.beanClassDescription.hashCode();
            result = 31 * result + this.props.hashCode();
            result = 31 * result + this.methodReturn.hashCode();
            return result;
        }
    }

    private static class SingleFieldStackManipulationSupplier<T extends OptimizedBeanPropertyWriter<T>>
    implements SinglePropStackManipulationSupplier<T> {
        private final TypeDescription beanClassDescription;
        private final MethodReturn methodReturn;
        private static Map<Integer, SingleFieldStackManipulationSupplier<?>> cache = new HashMap();

        SingleFieldStackManipulationSupplier(TypeDescription beanClassDescription, MethodReturn methodReturn) {
            this.beanClassDescription = beanClassDescription;
            this.methodReturn = methodReturn;
        }

        static <G extends OptimizedBeanPropertyWriter<G>> SingleFieldStackManipulationSupplier<G> of(TypeDescription beanClassDescription, MethodReturn methodReturn) {
            int key = beanClassDescription.hashCode() + methodReturn.hashCode();
            SingleFieldStackManipulationSupplier<Object> result = cache.get(key);
            if (result == null) {
                result = new SingleFieldStackManipulationSupplier(beanClassDescription, methodReturn);
                cache.put(key, result);
            }
            return result;
        }

        @Override
        public StackManipulation supply(T prop) {
            return new SingleFieldStackManipulation<T>(this.beanClassDescription, prop, this.methodReturn);
        }
    }

    private static class SingleFieldStackManipulation<T extends OptimizedBeanPropertyWriter<T>>
    extends AbstractSinglePropStackManipulation<T> {
        SingleFieldStackManipulation(TypeDescription beanClassDescription, T prop, MethodReturn methodReturn) {
            super(beanClassDescription, prop, methodReturn);
        }

        @Override
        protected StackManipulation invocationOperation(AnnotatedMember annotatedMember, TypeDefinition beanClassDescription) {
            String fieldName = annotatedMember.getName();
            FieldList matchingFields = (FieldList)beanClassDescription.getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)fieldName));
            if (matchingFields.size() == 1) {
                return FieldAccess.forField((FieldDescription)((FieldDescription)matchingFields.getOnly())).read();
            }
            if (matchingFields.isEmpty()) {
                return this.invocationOperation(annotatedMember, (TypeDefinition)beanClassDescription.getSuperClass());
            }
            throw new IllegalStateException("Could not find definition of field: " + fieldName);
        }
    }

    private static class SingleMethodStackManipulationSupplier<T extends OptimizedBeanPropertyWriter<T>>
    implements SinglePropStackManipulationSupplier<T> {
        private final TypeDescription beanClassDescription;
        private final MethodReturn methodReturn;
        private static Map<Integer, SingleMethodStackManipulationSupplier> cache = new HashMap<Integer, SingleMethodStackManipulationSupplier>();

        SingleMethodStackManipulationSupplier(TypeDescription beanClassDescription, MethodReturn methodReturn) {
            this.beanClassDescription = beanClassDescription;
            this.methodReturn = methodReturn;
        }

        static <G extends OptimizedBeanPropertyWriter<G>> SingleMethodStackManipulationSupplier<G> of(TypeDescription beanClassDescription, MethodReturn methodReturn) {
            int key = beanClassDescription.hashCode() + methodReturn.hashCode();
            SingleMethodStackManipulationSupplier result = cache.get(key);
            if (result == null) {
                result = new SingleMethodStackManipulationSupplier(beanClassDescription, methodReturn);
                cache.put(key, result);
            }
            return result;
        }

        @Override
        public StackManipulation supply(T prop) {
            return new SingleMethodStackManipulation<T>(this.beanClassDescription, prop, this.methodReturn);
        }
    }

    private static class SingleMethodStackManipulation<T extends OptimizedBeanPropertyWriter<T>>
    extends AbstractSinglePropStackManipulation<T> {
        private static final TypeDescription OBJECT_TYPE_DESCRIPTION = TypeDescription.ForLoadedType.of(Object.class);

        SingleMethodStackManipulation(TypeDescription beanClassDescription, T prop, MethodReturn methodReturn) {
            super(beanClassDescription, prop, methodReturn);
        }

        @Override
        protected StackManipulation invocationOperation(AnnotatedMember annotatedMember, TypeDefinition beanClassDescription) {
            String methodName = annotatedMember.getName();
            MethodList<MethodDescription> matchingMethods = this.getMatchingMethods(beanClassDescription, methodName);
            if (matchingMethods.size() == 1) {
                return MethodInvocation.invoke((MethodDescription)((MethodDescription)matchingMethods.getOnly()));
            }
            if (matchingMethods.isEmpty()) {
                Object klass = beanClassDescription;
                LinkedList<TypeDefinition> toProcess = new LinkedList<TypeDefinition>();
                do {
                    toProcess.addAll((Collection<TypeDefinition>)klass.getInterfaces());
                    if (OBJECT_TYPE_DESCRIPTION.equals(klass) || klass.getSuperClass() == null) {
                        HashSet<TypeDefinition> seen = new HashSet<TypeDefinition>(toProcess);
                        while (!toProcess.isEmpty()) {
                            TypeDefinition iface = (TypeDefinition)toProcess.poll();
                            MethodList<MethodDescription> matches = this.getMatchingMethods(iface, methodName);
                            if (matches.size() == 1) {
                                return MethodInvocation.invoke((MethodDescription)((MethodDescription)matches.getOnly()));
                            }
                            if (matches.size() > 1) {
                                throw new IllegalStateException("Multiple definitions of method " + methodName + " found");
                            }
                            for (TypeDefinition i : iface.getInterfaces()) {
                                if (seen.contains(i)) continue;
                                seen.add(i);
                                toProcess.add(i);
                            }
                        }
                        throw new IllegalStateException("Could not find definition of method: " + methodName);
                    }
                    MethodList<MethodDescription> matches = this.getMatchingMethods((TypeDefinition)klass, methodName);
                    if (matches.size() == 1) {
                        return MethodInvocation.invoke((MethodDescription)((MethodDescription)matches.getOnly()));
                    }
                    if (matches.size() <= 1) continue;
                    throw new IllegalStateException("Multiple definitions of method " + methodName + " found");
                } while ((klass = klass.isInterface() ? OBJECT_TYPE_DESCRIPTION : klass.getSuperClass()) != null);
                throw new IllegalStateException("Could not find definition of method: " + methodName);
            }
            throw new IllegalStateException("Multiple definitions of method " + methodName + " found");
        }

        private MethodList<MethodDescription> getMatchingMethods(TypeDefinition beanClassDescription, String methodName) {
            return (MethodList)beanClassDescription.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)methodName));
        }
    }

    private static abstract class AbstractSinglePropStackManipulation<T extends OptimizedBeanPropertyWriter<T>>
    extends AbstractPropertyStackManipulation {
        private final TypeDescription beanClassDescription;
        private final T prop;
        private final MethodReturn methodReturn;

        AbstractSinglePropStackManipulation(TypeDescription beanClassDescription, T prop, MethodReturn methodReturn) {
            super(LocalVarIndexCalculator.INSTANCE, false);
            this.methodReturn = methodReturn;
            this.beanClassDescription = beanClassDescription;
            this.prop = prop;
        }

        protected abstract StackManipulation invocationOperation(AnnotatedMember var1, TypeDefinition var2);

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            ArrayList<Object> operations = new ArrayList<Object>();
            operations.add(this.loadLocalVar());
            AnnotatedMember member = this.prop.getMember();
            operations.add(this.invocationOperation(member, (TypeDefinition)this.beanClassDescription));
            operations.add(this.methodReturn);
            StackManipulation.Compound compound = new StackManipulation.Compound(operations);
            return compound.apply(methodVisitor, implementationContext);
        }

        private StackManipulation loadLocalVar() {
            return MethodVariableAccess.REFERENCE.loadFrom(this.localVarIndex());
        }
    }

    private static class CreateLocalVarStackManipulation
    extends AbstractCreateLocalVarStackManipulation {
        private static Map<TypeDescription, CreateLocalVarStackManipulation> cache = new HashMap<TypeDescription, CreateLocalVarStackManipulation>();

        CreateLocalVarStackManipulation(TypeDescription beanClassDescription) {
            super(beanClassDescription, LocalVarIndexCalculator.INSTANCE, false);
        }

        static CreateLocalVarStackManipulation of(TypeDescription beanClassDescription) {
            CreateLocalVarStackManipulation result = cache.get(beanClassDescription);
            if (result == null) {
                result = new CreateLocalVarStackManipulation(beanClassDescription);
                cache.put(beanClassDescription, result);
            }
            return result;
        }
    }

    private static enum LocalVarIndexCalculator implements AbstractPropertyStackManipulation.LocalVarIndexCalculator
    {
        INSTANCE;


        @Override
        public int calculate() {
            return 3;
        }
    }
}

