/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import tools.jackson.jr.ob.JSON;
import tools.jackson.jr.ob.impl.BeanConstructors;
import tools.jackson.jr.ob.impl.JSONReader;
import tools.jackson.jr.ob.impl.JSONWriter;
import tools.jackson.jr.ob.impl.POJODefinition;
import tools.jackson.jr.ob.impl.RecordsHelpers;

public class BeanPropertyIntrospector {
    protected static final POJODefinition.Prop[] NO_PROPS = new POJODefinition.Prop[0];
    private static final BeanPropertyIntrospector INSTANCE = new BeanPropertyIntrospector();

    public static BeanPropertyIntrospector instance() {
        return INSTANCE;
    }

    public POJODefinition pojoDefinitionForDeserialization(JSONReader jSONReader, Class<?> clazz) {
        return this._introspectDefinition(clazz, false, jSONReader.features(), RecordsHelpers.isRecordType(clazz));
    }

    public POJODefinition pojoDefinitionForSerialization(JSONWriter jSONWriter, Class<?> clazz) {
        return this._introspectDefinition(clazz, true, jSONWriter.features(), RecordsHelpers.isRecordType(clazz));
    }

    private POJODefinition _introspectDefinition(Class<?> clazz, boolean bl, int n, boolean bl2) {
        POJODefinition.Prop[] propArray;
        BeanConstructors beanConstructors;
        boolean bl3 = bl2 && bl && JSON.Feature.WRITE_RECORD_FIELDS_IN_DECLARATION_ORDER.isEnabled(n);
        AbstractMap abstractMap = bl && !bl3 ? new TreeMap() : new LinkedHashMap();
        if (bl) {
            if (bl3) {
                BeanPropertyIntrospector.derivePropertiesFromRecordConstructor(clazz, abstractMap, POJODefinition.PropBuilder::new);
            }
            beanConstructors = null;
        } else {
            beanConstructors = new BeanConstructors(clazz);
            if (bl2) {
                Constructor<?> constructor = BeanPropertyIntrospector.derivePropertiesFromRecordConstructor(clazz, abstractMap, POJODefinition.PropBuilder::new);
                beanConstructors.addRecordConstructor(constructor);
            } else {
                BeanPropertyIntrospector.addNonRecordConstructors(clazz, beanConstructors);
            }
        }
        BeanPropertyIntrospector._introspect(clazz, abstractMap, n, bl2);
        int n2 = abstractMap.size();
        if (n2 == 0) {
            propArray = NO_PROPS;
        } else {
            propArray = new POJODefinition.Prop[n2];
            int n3 = 0;
            for (POJODefinition.PropBuilder propBuilder : abstractMap.values()) {
                propArray[n3++] = propBuilder.build();
            }
        }
        return new POJODefinition(clazz, propArray, beanConstructors);
    }

    public static <P> Constructor<?> derivePropertiesFromRecordConstructor(Class<?> clazz, Map<String, P> map, Function<String, P> function) {
        Constructor<?> constructor = BeanPropertyIntrospector._getCanonicalRecordConstructor(clazz);
        for (Parameter parameter : constructor.getParameters()) {
            BeanPropertyIntrospector._addPropertiesFromMap(map, parameter.getName(), function);
        }
        return constructor;
    }

    private static POJODefinition.PropBuilder _propFrom(Map<String, POJODefinition.PropBuilder> map, String string) {
        return BeanPropertyIntrospector._addPropertiesFromMap(map, string, POJODefinition.Prop::builder);
    }

    private static <P> P _addPropertiesFromMap(Map<String, P> map, String string, Function<String, P> function) {
        return map.computeIfAbsent(string, function);
    }

    public static void addNonRecordConstructors(Class<?> clazz, BeanConstructors beanConstructors) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length == 0) {
                beanConstructors.addNoArgsConstructor(constructor);
                continue;
            }
            if (classArray.length != 1) continue;
            Class<?> clazz2 = classArray[0];
            if (clazz2 == String.class) {
                beanConstructors.addStringConstructor(constructor);
                continue;
            }
            if (clazz2 == Integer.class || clazz2 == Integer.TYPE) {
                beanConstructors.addIntConstructor(constructor);
                continue;
            }
            if (clazz2 != Long.class && clazz2 != Long.TYPE) continue;
            beanConstructors.addLongConstructor(constructor);
        }
    }

    private static Constructor<?> _getCanonicalRecordConstructor(Class<?> clazz) {
        Constructor<?> constructor = RecordsHelpers.findCanonicalConstructor(clazz);
        if (constructor == null) {
            throw new IllegalArgumentException("Unable to find canonical constructor of Record type `" + clazz.getClass().getName() + "`");
        }
        return constructor;
    }

    private static void _introspect(Class<?> clazz, Map<String, POJODefinition.PropBuilder> map, int n, boolean bl) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        if (!bl) {
            BeanPropertyIntrospector._introspect(clazz.getSuperclass(), map, n, bl);
        }
        boolean bl2 = JSON.Feature.INCLUDE_STATIC_FIELDS.isDisabled(n);
        boolean bl3 = bl || JSON.Feature.USE_FIELD_MATCHING_GETTERS.isEnabled(n);
        LinkedHashMap<String, Field> linkedHashMap = bl3 ? new LinkedHashMap<String, Field>() : null;
        for (Field accessibleObject : clazz.getDeclaredFields()) {
            if (accessibleObject.isEnumConstant() || accessibleObject.isSynthetic() || Modifier.isStatic(accessibleObject.getModifiers()) && (bl2 || Modifier.isFinal(accessibleObject.getModifiers()))) continue;
            if (linkedHashMap != null) {
                linkedHashMap.put(accessibleObject.getName(), accessibleObject);
            }
            if (!Modifier.isPublic(accessibleObject.getModifiers())) continue;
            BeanPropertyIntrospector._propFrom(map, accessibleObject.getName()).withField(accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Object object;
            int n2 = ((Method)accessibleObject).getModifiers();
            if (Modifier.isStatic(n2) || ((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge() || BeanPropertyIntrospector.isGroovyMetaClass(((Method)accessibleObject).getReturnType())) continue;
            Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
            if (classArray.length == 0) {
                Field field;
                if (!Modifier.isPublic(n2) || (object = ((Method)accessibleObject).getReturnType()) == Void.class) continue;
                String string = ((Method)accessibleObject).getName();
                if (string.startsWith("get")) {
                    if (string.length() <= 3) continue;
                    string = BeanPropertyIntrospector.decap(string.substring(3));
                    BeanPropertyIntrospector._propFrom(map, string).withGetter((Method)accessibleObject);
                    continue;
                }
                if (string.startsWith("is")) {
                    if (string.length() <= 2) continue;
                    string = BeanPropertyIntrospector.decap(string.substring(2));
                    BeanPropertyIntrospector._propFrom(map, string).withIsGetter((Method)accessibleObject);
                    continue;
                }
                if (!bl3 || (field = (Field)linkedHashMap.get(string)) == null || !Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !((Method)accessibleObject).getReturnType().equals(field.getType())) continue;
                BeanPropertyIntrospector._propFrom(map, string).withGetter((Method)accessibleObject);
                continue;
            }
            if (classArray.length != 1 || !((String)(object = ((Method)accessibleObject).getName())).startsWith("set") || ((String)object).length() == 3) continue;
            object = BeanPropertyIntrospector.decap(((String)object).substring(3));
            BeanPropertyIntrospector._propFrom(map, (String)object).withSetter((Method)accessibleObject);
        }
    }

    private static String decap(String string) {
        char c;
        char c2 = string.charAt(0);
        if (!(c2 == (c = Character.toLowerCase(c2)) || string.length() != 1 && Character.isUpperCase(string.charAt(1)))) {
            char[] cArray = string.toCharArray();
            cArray[0] = c;
            return new String(cArray);
        }
        return string;
    }

    protected static boolean isGroovyMetaClass(Class<?> clazz) {
        return "groovy.lang.MetaClass".equals(clazz.getName());
    }
}

