/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.DumpSettingsBuilder;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.common.Anchor;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.common.SpecVersion;
import org.snakeyaml.engine.v2.emitter.Emitter;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.ImplicitTuple;
import org.snakeyaml.engine.v2.events.MappingEndEvent;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceEndEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamEndEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;
import org.snakeyaml.engine.v2.nodes.Tag;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamWriteContext;
import tools.jackson.dataformat.yaml.PackageVersion;
import tools.jackson.dataformat.yaml.WriterWrapper;
import tools.jackson.dataformat.yaml.YAMLWriteFeature;
import tools.jackson.dataformat.yaml.util.StringQuotingChecker;

public class YAMLGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected static final Pattern PLAIN_NUMBER_P = Pattern.compile("[+-]?[0-9]*(\\.[0-9]*)?");
    protected static final String TAG_BINARY = Tag.BINARY.toString();
    private static final ScalarStyle STYLE_UNQUOTED_NAME = ScalarStyle.PLAIN;
    private static final ScalarStyle STYLE_SCALAR = ScalarStyle.PLAIN;
    private static final ScalarStyle STYLE_QUOTED = ScalarStyle.DOUBLE_QUOTED;
    private static final ScalarStyle STYLE_LITERAL;
    private static final ScalarStyle STYLE_BASE64;
    private static final ScalarStyle STYLE_PLAIN;
    protected int _formatWriteFeatures;
    protected Writer _writer;
    protected DumpSettings _outputOptions;
    protected final boolean _cfgMinimizeQuotes;
    protected final SpecVersion _docVersion;
    protected SimpleStreamWriteContext _streamWriteContext;
    protected Emitter _emitter;
    protected String _objectId;
    protected String _typeId;
    protected int _rootValueCount;
    protected final StringQuotingChecker _quotingChecker;
    private static final ImplicitTuple NO_TAGS;
    private static final ImplicitTuple EXPLICIT_TAGS;

    public YAMLGenerator(ObjectWriteContext writeContext, IOContext ioCtxt, int streamWriteFeatures, int yamlFeatures, StringQuotingChecker quotingChecker, Writer out, SpecVersion version, DumpSettings dumpOptions) {
        super(writeContext, ioCtxt, streamWriteFeatures);
        DupDetector dups = StreamWriteFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamWriteFeatures) ? DupDetector.rootDetector((JsonGenerator)this) : null;
        this._streamWriteContext = SimpleStreamWriteContext.createRootContext((DupDetector)dups);
        this._formatWriteFeatures = yamlFeatures;
        this._cfgMinimizeQuotes = YAMLWriteFeature.MINIMIZE_QUOTES.enabledIn(this._formatWriteFeatures);
        this._quotingChecker = quotingChecker;
        this._writer = out;
        this._docVersion = version;
        if (dumpOptions == null) {
            dumpOptions = this.buildDumperOptions(streamWriteFeatures, yamlFeatures, version);
        }
        this._outputOptions = dumpOptions;
        this._emitter = new Emitter(this._outputOptions, (StreamDataWriter)new WriterWrapper(this._writer));
        this._emit((Event)new StreamStartEvent());
        this._emitStartDocument();
    }

    protected DumpSettings buildDumperOptions(int streamWriteFeatures, int yamlFeatures, SpecVersion version) {
        DumpSettingsBuilder opt = DumpSettings.builder();
        if (YAMLWriteFeature.CANONICAL_OUTPUT.enabledIn(this._formatWriteFeatures)) {
            opt.setCanonical(true);
        } else {
            opt.setCanonical(false);
            opt.setDefaultFlowStyle(FlowStyle.BLOCK);
        }
        opt.setSplitLines(YAMLWriteFeature.SPLIT_LINES.enabledIn(this._formatWriteFeatures));
        if (YAMLWriteFeature.INDENT_ARRAYS.enabledIn(this._formatWriteFeatures)) {
            opt.setIndicatorIndent(1);
            opt.setIndent(2);
        }
        if (YAMLWriteFeature.INDENT_ARRAYS_WITH_INDICATOR.enabledIn(this._formatWriteFeatures)) {
            opt.setIndicatorIndent(2);
            opt.setIndentWithIndicator(true);
        }
        if (YAMLWriteFeature.ALLOW_LONG_KEYS.enabledIn(this._formatWriteFeatures)) {
            opt.setMaxSimpleKeyLength(1024);
        }
        opt.setYamlDirective(Optional.ofNullable(version));
        return opt.build();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public final Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public final void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    public Object streamWriteOutputTarget() {
        return this._writer;
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    public final boolean isEnabled(YAMLWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    public JsonGenerator writeName(String name) throws JacksonException {
        if (!this._streamWriteContext.writeName(name)) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        this._writeFieldName(name);
        return this;
    }

    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        if (!this._streamWriteContext.writeName(name.getValue())) {
            this._reportError("Cannotwrite a property name, expecting a value");
        }
        this._writeFieldName(name.getValue());
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        String idStr = Long.valueOf(id).toString();
        if (!this._streamWriteContext.writeName(idStr)) {
            this._reportError("Cannot write a property id, expecting a value");
        }
        this._writeScalar(idStr, "int", STYLE_SCALAR);
        return this;
    }

    private final void _writeFieldName(String name) throws JacksonException {
        this._writeScalar(name, "string", this._quotingChecker.needToQuoteName(name) ? STYLE_QUOTED : STYLE_UNQUOTED_NAME);
    }

    public final void flush() {
        if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._writer.flush();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    public void close() {
        if (!this.isClosed()) {
            this._emitEndDocument();
            this._emit((Event)new StreamEndEvent());
            super.close();
        }
    }

    protected void _closeInput() throws IOException {
        if (this._writer != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                this._writer.close();
            } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                this._writer.flush();
            }
        }
    }

    public JsonGenerator writeStartArray() throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this._streamWriteConstraints.validateNestingDepth(this._streamWriteContext.getNestingDepth());
        FlowStyle style = this._outputOptions.getDefaultFlowStyle();
        String yamlTag = this._typeId;
        boolean implicit = yamlTag == null;
        Optional<Anchor> anchor = Optional.ofNullable(this._objectId).map(s -> new Anchor(s));
        if (anchor.isPresent()) {
            this._objectId = null;
        }
        this._emit((Event)new SequenceStartEvent(anchor, Optional.ofNullable(yamlTag), implicit, style));
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this.writeStartArray();
        this.assignCurrentValue(currValue);
        return this;
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._streamWriteContext.typeDesc());
        }
        this._typeId = null;
        this._streamWriteContext = this._streamWriteContext.getParent();
        this._emit((Event)new SequenceEndEvent());
        return this;
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null);
        this._streamWriteConstraints.validateNestingDepth(this._streamWriteContext.getNestingDepth());
        FlowStyle style = this._outputOptions.getDefaultFlowStyle();
        String yamlTag = this._typeId;
        boolean implicit = yamlTag == null;
        Optional<Anchor> anchor = Optional.ofNullable(this._objectId).map(s -> new Anchor(s));
        if (anchor.isPresent()) {
            this._objectId = null;
        }
        this._emit((Event)new MappingStartEvent(anchor, Optional.ofNullable(yamlTag), implicit, style));
        return this;
    }

    public JsonGenerator writeStartObject(Object currValue) throws JacksonException {
        this.writeStartObject();
        this.assignCurrentValue(currValue);
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._streamWriteContext.typeDesc());
        }
        this._typeId = null;
        this._streamWriteContext = this._streamWriteContext.getParent();
        this._emit((Event)new MappingEndEvent());
        return this;
    }

    public JsonGenerator writeString(String text) throws JacksonException {
        if (text == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write String value");
        if (text.isEmpty()) {
            this._writeScalar(text, "string", STYLE_QUOTED);
            return this;
        }
        ScalarStyle style = this._cfgMinimizeQuotes ? (text.indexOf(10) >= 0 ? STYLE_LITERAL : (this._quotingChecker.needToQuoteValue(text) || YAMLWriteFeature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS.enabledIn(this._formatWriteFeatures) && PLAIN_NUMBER_P.matcher(text).matches() ? STYLE_QUOTED : STYLE_PLAIN)) : (YAMLWriteFeature.LITERAL_BLOCK_STYLE.enabledIn(this._formatWriteFeatures) && text.indexOf(10) >= 0 ? STYLE_LITERAL : STYLE_QUOTED);
        this._writeScalar(text, "string", style);
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        return this.writeString(new String(text, offset, len));
    }

    public JsonGenerator writeString(SerializableString sstr) throws JacksonException {
        return this.writeString(sstr.toString());
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return this.writeString(new String(text, offset, len, StandardCharsets.UTF_8));
    }

    public JsonGenerator writeRaw(String text) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char c) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (data == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        this._writeScalarBinary(b64variant, data);
        return this;
    }

    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        this._verifyValueWrite("write boolean value");
        this._writeScalar(state ? "true" : "false", "bool", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        return this.writeNumber((int)v);
    }

    public JsonGenerator writeNumber(int v) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(v), "int", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNumber(long l) throws JacksonException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return this.writeNumber((int)l);
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(l), "long", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(v.toString()), "java.math.BigInteger", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNumber(double d) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(d), "double", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNumber(float f) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(f), "float", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal dec) throws JacksonException {
        if (dec == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this._writeScalar(str, "java.math.BigDecimal", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        if (encodedValue == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        this._writeScalar(encodedValue, "number", STYLE_SCALAR);
        return this;
    }

    public JsonGenerator writeNull() throws JacksonException {
        this._verifyValueWrite("write null value");
        this._writeScalar("null", "object", STYLE_SCALAR);
        return this;
    }

    public boolean canWriteObjectId() {
        return YAMLWriteFeature.USE_NATIVE_OBJECT_ID.enabledIn(this._formatWriteFeatures);
    }

    public boolean canWriteTypeId() {
        return YAMLWriteFeature.USE_NATIVE_TYPE_ID.enabledIn(this._formatWriteFeatures);
    }

    public JsonGenerator writeTypeId(Object id) throws JacksonException {
        this._typeId = String.valueOf(id);
        return this;
    }

    public JsonGenerator writeObjectRef(Object id) throws JacksonException {
        this._verifyValueWrite("write Object reference");
        AliasEvent evt = new AliasEvent(Optional.of(String.valueOf(id)).map(s -> new Anchor(s)));
        this._emit((Event)evt);
        return this;
    }

    public JsonGenerator writeObjectId(Object id) throws JacksonException {
        this._objectId = id == null ? null : String.valueOf(id);
        return this;
    }

    protected final void _verifyValueWrite(String typeMsg) throws JacksonException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Cannot " + typeMsg + ", expecting a property name");
        }
        if (this._streamWriteContext.inRoot() && this._streamWriteContext.getCurrentIndex() > 0) {
            this._emitEndDocument();
            this._emitStartDocument();
        }
    }

    protected void _releaseBuffers() {
    }

    protected void _writeScalar(String value, String type, ScalarStyle style) throws JacksonException {
        this._emit((Event)this._scalarEvent(value, style));
    }

    private void _writeScalarBinary(Base64Variant b64variant, byte[] data) throws JacksonException {
        if (b64variant == Base64Variants.getDefaultVariant()) {
            b64variant = Base64Variants.MIME;
        }
        String lf = this._lf();
        String encoded = b64variant.encode(data, false, lf);
        this._emit((Event)new ScalarEvent(Optional.empty(), Optional.ofNullable(TAG_BINARY), EXPLICIT_TAGS, encoded, STYLE_BASE64));
    }

    protected ScalarEvent _scalarEvent(String value, ScalarStyle style) {
        Optional<Anchor> anchor;
        String yamlTag = this._typeId;
        if (yamlTag != null) {
            this._typeId = null;
        }
        if ((anchor = Optional.ofNullable(this._objectId).map(s -> new Anchor(s))).isPresent()) {
            this._objectId = null;
        }
        return new ScalarEvent(anchor, Optional.ofNullable(yamlTag), NO_TAGS, value, style);
    }

    protected String _lf() {
        return this._outputOptions.getBestLineBreak();
    }

    protected void _emitStartDocument() throws JacksonException {
        Map noTags = Collections.emptyMap();
        boolean startMarker = YAMLWriteFeature.WRITE_DOC_START_MARKER.enabledIn(this._formatWriteFeatures);
        this._emit((Event)new DocumentStartEvent(startMarker, this._outputOptions.getYamlDirective(), noTags));
    }

    protected void _emitEndDocument() throws JacksonException {
        this._emit((Event)new DocumentEndEvent(false));
    }

    protected final void _emit(Event e) {
        this._emitter.emit(e);
    }

    static {
        STYLE_BASE64 = STYLE_LITERAL = ScalarStyle.LITERAL;
        STYLE_PLAIN = ScalarStyle.PLAIN;
        NO_TAGS = new ImplicitTuple(true, true);
        EXPLICIT_TAGS = new ImplicitTuple(false, false);
    }
}

