/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import tools.jackson.core.FormatFeature;

public enum XmlReadFeature implements FormatFeature
{
    AUTO_DETECT_XSI_TYPE(true),
    EMPTY_ELEMENT_AS_NULL(false),
    PROCESS_XSI_NIL(true);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (XmlReadFeature f : XmlReadFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private XmlReadFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public int getMask() {
        return this._mask;
    }

    public boolean enabledIn(int flags) {
        return (flags & this.getMask()) != 0;
    }
}

