/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.ser;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.Stax2WriterAdapter;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamWriteContext;
import tools.jackson.dataformat.xml.PackageVersion;
import tools.jackson.dataformat.xml.XmlNameProcessor;
import tools.jackson.dataformat.xml.XmlPrettyPrinter;
import tools.jackson.dataformat.xml.XmlWriteFeature;
import tools.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import tools.jackson.dataformat.xml.util.StaxUtil;

public class ToXmlGenerator
extends GeneratorBase {
    protected static final String DEFAULT_UNKNOWN_ELEMENT = "unknown";
    protected final XMLStreamWriter2 _xmlWriter;
    protected final XMLStreamWriter _originalXmlWriter;
    protected final XmlPrettyPrinter _xmlPrettyPrinter;
    protected int _formatFeatures;
    protected final boolean _stax2Emulation;
    protected SimpleStreamWriteContext _streamWriteContext;
    protected XmlNameProcessor _nameProcessor;
    protected boolean _initialized;
    protected QName _nextName = null;
    protected boolean _nextIsAttribute = false;
    protected boolean _nextIsUnwrapped = false;
    protected boolean _nextIsCData = false;
    protected LinkedList<QName> _elementNameStack = new LinkedList();
    protected XmlNameProcessor.XmlName _nameToEncode = new XmlNameProcessor.XmlName();

    public ToXmlGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int xmlFeatures, XMLStreamWriter sw, XmlPrettyPrinter pp, XmlNameProcessor nameProcessor) {
        super(writeCtxt, ioCtxt, streamWriteFeatures);
        this._formatFeatures = xmlFeatures;
        this._originalXmlWriter = sw;
        this._xmlWriter = Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)sw);
        this._stax2Emulation = this._xmlWriter != sw;
        this._xmlPrettyPrinter = pp;
        DupDetector dups = StreamWriteFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamWriteFeatures) ? DupDetector.rootDetector((JsonGenerator)this) : null;
        this._streamWriteContext = SimpleStreamWriteContext.createRootContext((DupDetector)dups);
        this._nameProcessor = nameProcessor;
    }

    public void initGenerator() throws JacksonException {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        try {
            boolean xmlDeclWritten;
            if (XmlWriteFeature.WRITE_XML_1_1.enabledIn(this._formatFeatures)) {
                this._xmlWriter.writeStartDocument("UTF-8", "1.1");
                xmlDeclWritten = true;
            } else if (XmlWriteFeature.WRITE_XML_DECLARATION.enabledIn(this._formatFeatures)) {
                this._xmlWriter.writeStartDocument("UTF-8", "1.0");
                xmlDeclWritten = true;
            } else {
                xmlDeclWritten = false;
            }
            if (xmlDeclWritten && this._xmlPrettyPrinter != null && !this._stax2Emulation) {
                this._xmlPrettyPrinter.writePrologLinefeed(this._xmlWriter);
            }
            if (XmlWriteFeature.AUTO_DETECT_XSI_TYPE.enabledIn(this._formatFeatures)) {
                this._xmlWriter.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public final Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public final void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    protected PrettyPrinter _constructDefaultPrettyPrinter() {
        return new DefaultXmlPrettyPrinter();
    }

    public Object streamWriteOutputTarget() {
        return this._originalXmlWriter;
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public final boolean isEnabled(XmlWriteFeature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public ToXmlGenerator configure(XmlWriteFeature f, boolean state) {
        this._formatFeatures = state ? (this._formatFeatures |= f.getMask()) : (this._formatFeatures &= ~f.getMask());
        return this;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    public boolean inRoot() {
        return this._streamWriteContext.inRoot();
    }

    public XMLStreamWriter getStaxWriter() {
        return this._xmlWriter;
    }

    public void setNextIsAttribute(boolean isAttribute) {
        this._nextIsAttribute = isAttribute;
    }

    public void setNextIsUnwrapped(boolean isUnwrapped) {
        this._nextIsUnwrapped = isUnwrapped;
    }

    public void setNextIsCData(boolean isCData) {
        this._nextIsCData = isCData;
    }

    public final void setNextName(QName name) {
        this._nextName = name;
    }

    public final boolean setNextNameIfMissing(QName name) {
        if (this._nextName == null) {
            this._nextName = name;
            return true;
        }
        return false;
    }

    public void startWrappedValue(QName wrapperName, QName wrappedName) throws JacksonException {
        if (wrapperName != null) {
            try {
                if (this._xmlPrettyPrinter != null) {
                    this._xmlPrettyPrinter.writeStartElement(this._xmlWriter, wrapperName.getNamespaceURI(), wrapperName.getLocalPart());
                } else {
                    this._xmlWriter.writeStartElement(wrapperName.getNamespaceURI(), wrapperName.getLocalPart());
                }
            }
            catch (XMLStreamException e) {
                StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
            }
        }
        this.setNextName(wrappedName);
    }

    public void finishWrappedValue(QName wrapperName, QName wrappedName) throws JacksonException {
        if (wrapperName != null) {
            try {
                if (this._xmlPrettyPrinter != null) {
                    this._xmlPrettyPrinter.writeEndElement(this._xmlWriter, this._streamWriteContext.getEntryCount());
                } else {
                    this._xmlWriter.writeEndElement();
                }
            }
            catch (XMLStreamException e) {
                StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
            }
        }
    }

    public JsonGenerator writeRepeatedPropertyName() throws JacksonException {
        if (!this._streamWriteContext.writeName(this._nextName.getLocalPart())) {
            this._reportError("Can not write a property name, expecting a value");
        }
        return this;
    }

    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        return this.writeName(name.getValue());
    }

    public JsonGenerator writeName(String name) throws JacksonException {
        if (!this._streamWriteContext.writeName(name)) {
            this._reportError("Can not write a property name, expecting a value");
        }
        if (XmlWriteFeature.AUTO_DETECT_XSI_TYPE.enabledIn(this._formatFeatures) && "xsi:type".equals(name)) {
            this.setNextName(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"));
            this.setNextIsAttribute(true);
        } else {
            String ns;
            this._nameToEncode.namespace = ns = this._nextName == null ? "" : this._nextName.getNamespaceURI();
            this._nameToEncode.localPart = name;
            this._nameProcessor.encodeName(this._nameToEncode);
            this.setNextName(new QName(this._nameToEncode.namespace, this._nameToEncode.localPart));
        }
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        String name = Long.toString(id);
        return this.writeName(name);
    }

    public JsonGenerator writeStartArray() throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._xmlPrettyPrinter != null) {
            this._xmlPrettyPrinter.writeStartArray((JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(currValue);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._xmlPrettyPrinter != null) {
            this._xmlPrettyPrinter.writeStartArray((JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._streamWriteContext.typeDesc());
        }
        if (this._xmlPrettyPrinter != null) {
            this._xmlPrettyPrinter.writeEndArray((JsonGenerator)this, this._streamWriteContext.getEntryCount());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        return this;
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._xmlPrettyPrinter != null) {
            this._xmlPrettyPrinter.writeStartObject((JsonGenerator)this);
        } else {
            this._handleStartObject();
        }
        return this;
    }

    public JsonGenerator writeStartObject(Object currValue) throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(currValue);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._xmlPrettyPrinter != null) {
            this._xmlPrettyPrinter.writeStartObject((JsonGenerator)this);
        } else {
            this._handleStartObject();
        }
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        if (this._xmlPrettyPrinter != null) {
            int count = this._nextIsAttribute ? 0 : this._streamWriteContext.getEntryCount();
            this._xmlPrettyPrinter.writeEndObject((JsonGenerator)this, count);
        } else {
            this._handleEndObject();
        }
        return this;
    }

    public final void _handleStartObject() throws JacksonException {
        if (this._nextName == null) {
            this.handleMissingName();
        }
        this._elementNameStack.addLast(this._nextName);
        try {
            this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
    }

    public final void _handleEndObject() throws JacksonException {
        if (this._elementNameStack.isEmpty()) {
            throw this._constructWriteException("Can not write END_ELEMENT without open START_ELEMENT", (Object)this);
        }
        this._nextName = this._elementNameStack.removeLast();
        try {
            this._nextIsAttribute = false;
            this._xmlWriter.writeEndElement();
            if (this._elementNameStack.isEmpty() && this._xmlPrettyPrinter != null && !this._stax2Emulation) {
                this._xmlPrettyPrinter.writePrologLinefeed(this._xmlWriter);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
    }

    public JsonGenerator writeString(String text) throws JacksonException {
        if (text == null) {
            this.writeNull();
            return this;
        }
        this._verifyValueWrite("write String value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), text);
            } else if (this.checkNextIsUnwrapped()) {
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(text);
                } else {
                    this._xmlWriter.writeCharacters(text);
                }
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), text, this._nextIsCData);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(text);
                } else {
                    this._xmlWriter.writeCharacters(text);
                }
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write String value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), new String(text, offset, len));
            } else if (this.checkNextIsUnwrapped()) {
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(text, offset, len);
                } else {
                    this._xmlWriter.writeCharacters(text, offset, len);
                }
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), text, offset, len, this._nextIsCData);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                if (this._nextIsCData) {
                    this._xmlWriter.writeCData(text, offset, len);
                } else {
                    this._xmlWriter.writeCharacters(text, offset, len);
                }
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeString(SerializableString text) throws JacksonException {
        return this.writeString(text.getValue());
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int length) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int length) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text) throws JacksonException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRawValue");
        }
        try {
            this._verifyValueWrite("write raw value");
            if (this._nextName == null) {
                this.handleMissingName();
            }
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), text);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeRaw(text);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeRaw(text);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRawValue");
        }
        try {
            this._verifyValueWrite("write raw value");
            if (this._nextName == null) {
                this.handleMissingName();
            }
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), text.substring(offset, offset + len));
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeRaw(text, offset, len);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeRaw(text, offset, len);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRawValue");
        }
        this._verifyValueWrite("write raw value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), new String(text, offset, len));
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeRaw(text, offset, len);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeRaw(text, offset, len);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeRawValue(SerializableString text) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text) throws JacksonException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(text);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(text, offset, len);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(text, offset, len);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeRaw(char c) throws JacksonException {
        return this.writeRaw(String.valueOf(c));
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (data == null) {
            this.writeNull();
            return this;
        }
        this._verifyValueWrite("write Binary value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        org.codehaus.stax2.typed.Base64Variant stax2base64v = StaxUtil.toStax2Base64Variant(b64variant);
        try {
            if (this._nextIsAttribute) {
                byte[] fullBuffer = this.toFullBuffer(data, offset, len);
                this._xmlWriter.writeBinaryAttribute(stax2base64v, "", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), fullBuffer);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeBinary(stax2base64v, data, offset, len);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), stax2base64v, data, offset, len);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeBinary(stax2base64v, data, offset, len);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws JacksonException {
        if (data == null) {
            this.writeNull();
            return 0;
        }
        this._verifyValueWrite("write Binary value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        org.codehaus.stax2.typed.Base64Variant stax2base64v = StaxUtil.toStax2Base64Variant(b64variant);
        try {
            if (this._nextIsAttribute) {
                byte[] fullBuffer = this.toFullBuffer(data, dataLength);
                this._xmlWriter.writeBinaryAttribute(stax2base64v, "", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), fullBuffer);
            } else if (this.checkNextIsUnwrapped()) {
                this.writeStreamAsBinary(stax2base64v, data, dataLength);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), stax2base64v, this.toFullBuffer(data, dataLength), 0, dataLength);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this.writeStreamAsBinary(stax2base64v, data, dataLength);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return dataLength;
    }

    private void writeStreamAsBinary(org.codehaus.stax2.typed.Base64Variant stax2base64v, InputStream data, int len) throws IOException, XMLStreamException {
        int read;
        byte[] tmp = new byte[3];
        int offset = 0;
        while ((read = data.read(tmp, offset, Math.min(3 - offset, len))) != -1) {
            len -= read;
            if ((offset += read) == 3) {
                offset = 0;
                this._xmlWriter.writeBinary(stax2base64v, tmp, 0, 3);
            }
            if (len != 0) continue;
        }
        if (offset > 0) {
            this._xmlWriter.writeBinary(stax2base64v, tmp, 0, offset);
        }
    }

    private byte[] toFullBuffer(byte[] data, int offset, int len) {
        if (offset == 0 && len == data.length) {
            return data;
        }
        byte[] result = new byte[len];
        if (len > 0) {
            System.arraycopy(data, offset, result, 0, len);
        }
        return result;
    }

    private byte[] toFullBuffer(InputStream data, int len) throws JacksonException {
        int count;
        byte[] result = new byte[len];
        for (int offset = 0; offset < len; offset += count) {
            try {
                count = data.read(result, offset, len - offset);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            if (count >= 0) continue;
            throw this._constructWriteException("Too few bytes available: missing " + (len - offset) + " bytes (out of " + len + ")");
        }
        return result;
    }

    public JsonGenerator writeBoolean(boolean value) throws JacksonException {
        this._verifyValueWrite("write boolean value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeBooleanAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), value);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeBoolean(value);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), value);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeBoolean(value);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNull() throws JacksonException {
        this._verifyValueWrite("write null value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (!this._nextIsAttribute && !this.checkNextIsUnwrapped()) {
                boolean asXsiNil = this.isEnabled(XmlWriteFeature.WRITE_NULLS_AS_XSI_NIL);
                if (this._xmlPrettyPrinter != null) {
                    if (asXsiNil) {
                        this._xmlPrettyPrinter.writeLeafXsiNilElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                    } else {
                        this._xmlPrettyPrinter.writeLeafNullElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                    }
                } else if (asXsiNil) {
                    this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                    this._xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                    this._xmlWriter.writeEndElement();
                } else {
                    this._xmlWriter.writeEmptyElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                }
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        return this.writeNumber((int)v);
    }

    public JsonGenerator writeNumber(int i) throws JacksonException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeIntAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), i);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeInt(i);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), i);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeInt(i);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNumber(long l) throws JacksonException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeLongAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), l);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeLong(l);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), l);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeLong(l);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNumber(double d) throws JacksonException {
        if (Double.isInfinite(d) && this.isEnabled(XmlWriteFeature.WRITE_XML_SCHEMA_CONFORMING_FLOATS)) {
            return this.writeNumber(d > 0.0 ? "INF" : "-INF");
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeDoubleAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), d);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeDouble(d);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), d);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeDouble(d);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNumber(float f) throws JacksonException {
        if (Float.isInfinite(f) && this.isEnabled(XmlWriteFeature.WRITE_XML_SCHEMA_CONFORMING_FLOATS)) {
            return this.writeNumber(f > 0.0f ? "INF" : "-INF");
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeFloatAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), f);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeFloat(f);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), f);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeFloat(f);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal dec) throws JacksonException {
        if (dec == null) {
            this.writeNull();
            return this;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        boolean usePlain = this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN);
        try {
            if (this._nextIsAttribute) {
                if (usePlain) {
                    this._xmlWriter.writeAttribute("", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), dec.toPlainString());
                } else {
                    this._xmlWriter.writeDecimalAttribute("", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), dec);
                }
            } else if (this.checkNextIsUnwrapped()) {
                if (usePlain) {
                    this._xmlWriter.writeCharacters(dec.toPlainString());
                } else {
                    this._xmlWriter.writeDecimal(dec);
                }
            } else if (this._xmlPrettyPrinter != null) {
                if (usePlain) {
                    this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), dec.toPlainString(), false);
                } else {
                    this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), dec);
                }
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                if (usePlain) {
                    this._xmlWriter.writeCharacters(dec.toPlainString());
                } else {
                    this._xmlWriter.writeDecimal(dec);
                }
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNumber(BigInteger value) throws JacksonException {
        if (value == null) {
            this.writeNull();
            return this;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeIntegerAttribute("", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), value);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeInteger(value);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), value);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeInteger(value);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) throws JacksonException, UnsupportedOperationException {
        return this.writeString(encodedValue);
    }

    protected final void _verifyValueWrite(String typeMsg) throws JacksonException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Cannot " + typeMsg + ", expecting a property name");
        }
    }

    public void flush() throws JacksonException {
        if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._xmlWriter.flush();
            }
            catch (XMLStreamException e) {
                StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
            }
        }
    }

    protected void _closeInput() throws JacksonException {
        if (this.isEnabled(StreamWriteFeature.AUTO_CLOSE_CONTENT)) {
            try {
                while (true) {
                    TokenStreamContext ctxt;
                    if ((ctxt = this.streamWriteContext()).inArray()) {
                        this.writeEndArray();
                        continue;
                    }
                    if (ctxt.inObject()) {
                        this.writeEndObject();
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new StreamWriteException((JsonGenerator)this, (Throwable)e);
            }
        }
        try {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                this._xmlWriter.closeCompletely();
            } else {
                this._xmlWriter.close();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsWriteException(e, (JsonGenerator)this);
        }
    }

    protected void _releaseBuffers() {
    }

    protected boolean checkNextIsUnwrapped() {
        if (this._nextIsUnwrapped) {
            this._nextIsUnwrapped = false;
            return true;
        }
        return false;
    }

    protected void handleMissingName() {
        throw new IllegalStateException("No element/attribute name specified when trying to output element");
    }

    protected void _reportUnimplementedStax2(String missingMethod) throws JacksonException {
        throw this._constructWriteException("Underlying Stax XMLStreamWriter (of type " + this._originalXmlWriter.getClass().getName() + ") does not implement Stax2 API natively and is missing method '" + missingMethod + "': this breaks functionality such as indentation that relies on it. You need to upgrade to using compliant Stax implementation like Woodstox or Aalto");
    }
}

