/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf;

import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.io.CharTypes;
import tools.jackson.core.io.ContentReference;
import tools.jackson.dataformat.protobuf.schema.ProtobufField;
import tools.jackson.dataformat.protobuf.schema.ProtobufMessage;

public final class ProtobufReadContext
extends TokenStreamContext {
    protected final ProtobufReadContext _parent;
    protected ProtobufMessage _messageType;
    protected ProtobufField _field;
    protected String _currentName;
    protected Object _currentValue;
    protected int _endOffset;
    protected ProtobufReadContext _child = null;

    public ProtobufReadContext(ProtobufReadContext parent, ProtobufMessage messageType, int type, int endOffset) {
        this._parent = parent;
        this._messageType = messageType;
        this._type = type;
        this._endOffset = endOffset;
        this._index = -1;
        this._nestingDepth = parent == null ? 0 : parent._nestingDepth + 1;
    }

    protected void reset(ProtobufMessage messageType, int type, int endOffset) {
        this._messageType = messageType;
        this._type = type;
        this._index = -1;
        this._currentName = null;
        this._currentValue = null;
        this._endOffset = endOffset;
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static ProtobufReadContext createRootContext() {
        return new ProtobufReadContext(null, null, 0, Integer.MAX_VALUE);
    }

    public ProtobufReadContext createChildArrayContext(ProtobufField f) {
        this._field = f;
        ProtobufReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new ProtobufReadContext(this, this._messageType, 1, this._endOffset);
        } else {
            ctxt.reset(this._messageType, 1, this._endOffset);
        }
        return ctxt;
    }

    public ProtobufReadContext createChildArrayContext(ProtobufField f, int endOffset) {
        this._field = f;
        ProtobufReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new ProtobufReadContext(this, this._messageType, 1, 0);
        } else {
            ctxt.reset(this._messageType, 1, endOffset);
        }
        ctxt._field = f;
        return ctxt;
    }

    public ProtobufReadContext createChildObjectContext(ProtobufMessage messageType, ProtobufField f, int endOffset) {
        this._field = f;
        ProtobufReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new ProtobufReadContext(this, messageType, 2, endOffset);
            return ctxt;
        }
        ctxt.reset(messageType, 2, endOffset);
        return ctxt;
    }

    public String currentName() {
        return this._currentName;
    }

    public ProtobufReadContext getParent() {
        return this._parent;
    }

    public int adjustEnd(int bytesConsumed) {
        int newOffset;
        if (this._type == 0) {
            return this._endOffset;
        }
        this._endOffset = newOffset = this._endOffset - bytesConsumed;
        for (ProtobufReadContext ctxt = this._parent; ctxt != null; ctxt = ctxt.getParent()) {
            ctxt._adjustEnd(bytesConsumed);
        }
        return newOffset;
    }

    private void _adjustEnd(int bytesConsumed) {
        if (this._type != 0) {
            this._endOffset -= bytesConsumed;
        }
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    public ProtobufMessage getMessageType() {
        return this._messageType;
    }

    public ProtobufField getField() {
        return this._field;
    }

    public void setMessageType(ProtobufMessage mt) {
        this._messageType = mt;
    }

    public TokenStreamLocation startLocation(ContentReference srcRef, long byteOffset) {
        return new TokenStreamLocation(srcRef, byteOffset, -1, -1);
    }

    public void setCurrentName(String name) {
        this._currentName = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            case 2: {
                sb.append('{');
                if (this._currentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted((StringBuilder)sb, (String)this._currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append('}');
            }
        }
        return sb.toString();
    }
}

