/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.javaprop;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.deser.DeserializationContextExt;
import tools.jackson.databind.ser.SerializationContextExt;
import tools.jackson.dataformat.javaprop.JavaPropsFactory;
import tools.jackson.dataformat.javaprop.JavaPropsGenerator;
import tools.jackson.dataformat.javaprop.JavaPropsParser;
import tools.jackson.dataformat.javaprop.JavaPropsSchema;
import tools.jackson.dataformat.javaprop.PackageVersion;

public class JavaPropsMapper
extends ObjectMapper {
    private static final long serialVersionUID = 3L;

    public JavaPropsMapper() {
        this(new JavaPropsFactory());
    }

    public JavaPropsMapper(JavaPropsFactory f) {
        this(new Builder(f));
    }

    public JavaPropsMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new JavaPropsFactory());
    }

    public static Builder builder(JavaPropsFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static JavaPropsMapper shared() {
        return SharedWrapper.wrapped();
    }

    protected Object writeReplace() {
        return this._savedBuilderState;
    }

    protected Object readResolve() {
        throw new IllegalStateException("Should never deserialize `" + ((Object)((Object)this)).getClass().getName() + "` directly");
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JavaPropsFactory tokenStreamFactory() {
        return (JavaPropsFactory)this._streamFactory;
    }

    public <T> T readPropertiesAs(Properties props, JavaPropsSchema schema, Class<T> valueType) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        JavaPropsParser p = this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, schema, props);
        return (T)this.readValue((JsonParser)p, valueType);
    }

    public <T> T readPropertiesAs(Properties props, JavaPropsSchema schema, JavaType valueType) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        JavaPropsParser p = this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, schema, props);
        return (T)this.readValue((JsonParser)p, valueType);
    }

    public <T> T readPropertiesAs(Properties props, Class<T> valueType) throws IOException {
        return this.readPropertiesAs(props, JavaPropsSchema.emptySchema(), valueType);
    }

    public <T> T readPropertiesAs(Properties props, JavaType valueType) throws IOException {
        return this.readPropertiesAs(props, JavaPropsSchema.emptySchema(), valueType);
    }

    public <T> T readMapAs(Map<String, String> map, JavaPropsSchema schema, Class<T> valueType) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        JavaPropsParser p = this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, schema, map);
        return (T)this.readValue((JsonParser)p, valueType);
    }

    public <T> T readMapAs(Map<String, String> map, JavaPropsSchema schema, JavaType valueType) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        JavaPropsParser p = this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, schema, map);
        return (T)this.readValue((JsonParser)p, valueType);
    }

    public <T> T readMapAs(Map<String, String> map, Class<T> valueType) throws IOException {
        return this.readMapAs(map, JavaPropsSchema.emptySchema(), valueType);
    }

    public <T> T readMapAs(Map<String, String> map, JavaType valueType) throws IOException {
        return this.readMapAs(map, JavaPropsSchema.emptySchema(), valueType);
    }

    public <T> T readSystemPropertiesAs(JavaPropsSchema schema, Class<T> valueType) throws IOException {
        return this.readPropertiesAs(System.getProperties(), schema, valueType);
    }

    public <T> T readSystemPropertiesAs(JavaPropsSchema schema, JavaType valueType) throws IOException {
        return this.readPropertiesAs(System.getProperties(), schema, valueType);
    }

    public <T> T readEnvVariablesAs(JavaPropsSchema schema, Class<T> valueType) throws IOException {
        return this.readPropertiesAs(this._env(), schema, valueType);
    }

    public <T> T readEnvVariablesAs(JavaPropsSchema schema, JavaType valueType) throws IOException {
        return this.readPropertiesAs(this._env(), schema, valueType);
    }

    protected Properties _env() {
        Properties props = new Properties();
        props.putAll(System.getenv());
        return props;
    }

    public void writeValue(Map<?, ?> target, Object value) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException("Can not pass `null` target");
        }
        SerializationContextExt prov = this._serializationContext();
        try (JavaPropsGenerator g = this.tokenStreamFactory().createGenerator((ObjectWriteContext)prov, null, target);){
            this.writeValue((JsonGenerator)g, value);
        }
    }

    public void writeValue(Map<?, ?> target, Object value, JavaPropsSchema schema) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException("Can not pass `null` target");
        }
        SerializationContextExt prov = this._serializationContext();
        try (JavaPropsGenerator g = this.tokenStreamFactory().createGenerator((ObjectWriteContext)prov, schema, target);){
            this.writeValue((JsonGenerator)g, value);
        }
    }

    public Properties writeValueAsProperties(Object value) throws IOException {
        Properties props = new Properties();
        this.writeValue(props, value);
        return props;
    }

    public Properties writeValueAsProperties(Object value, JavaPropsSchema schema) throws IOException {
        Properties props = new Properties();
        this.writeValue(props, value, schema);
        return props;
    }

    public Map<String, String> writeValueAsMap(Object value) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.writeValue(map, value);
        return map;
    }

    public Map<String, String> writeValueAsMap(Object value, JavaPropsSchema schema) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.writeValue(map, value, schema);
        return map;
    }

    public static class Builder
    extends MapperBuilder<JavaPropsMapper, Builder> {
        public Builder(JavaPropsFactory f) {
            super((TokenStreamFactory)f);
            this.enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT});
            this._coercionConfigs.defaultCoercions().setAcceptBlankAsEmpty(Boolean.TRUE).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsEmpty);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public JavaPropsMapper build() {
            return new JavaPropsMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final JavaPropsMapper MAPPER = JavaPropsMapper.builder().build();

        private SharedWrapper() {
        }

        public static JavaPropsMapper wrapped() {
            return MAPPER;
        }
    }
}

