/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.javaprop;

import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.base.TextualTSFactory;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.dataformat.javaprop.JavaPropsFactoryBuilder;
import tools.jackson.dataformat.javaprop.JavaPropsGenerator;
import tools.jackson.dataformat.javaprop.JavaPropsParser;
import tools.jackson.dataformat.javaprop.JavaPropsSchema;
import tools.jackson.dataformat.javaprop.PackageVersion;
import tools.jackson.dataformat.javaprop.impl.PropertiesBackedGenerator;
import tools.jackson.dataformat.javaprop.impl.WriterBackedGenerator;
import tools.jackson.dataformat.javaprop.io.Latin1Reader;

public class JavaPropsFactory
extends TextualTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_JAVA_PROPERTIES = "java_properties";
    protected static final String CHARSET_ID_LATIN1 = "ISO-8859-1";
    static final JavaPropsSchema EMPTY_SCHEMA = JavaPropsSchema.emptySchema();

    public JavaPropsFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), 0, 0);
    }

    protected JavaPropsFactory(JavaPropsFactory src) {
        super((TextualTSFactory)src);
    }

    protected JavaPropsFactory(JavaPropsFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
    }

    public JavaPropsFactoryBuilder rebuild() {
        return new JavaPropsFactoryBuilder(this);
    }

    public static JavaPropsFactoryBuilder builder() {
        return new JavaPropsFactoryBuilder();
    }

    public JavaPropsFactory copy() {
        return new JavaPropsFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_JAVA_PROPERTIES;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof JavaPropsSchema;
    }

    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return null;
    }

    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return null;
    }

    public int getFormatReadFeatures() {
        return 0;
    }

    public int getFormatWriteFeatures() {
        return 0;
    }

    public JavaPropsParser createParser(ObjectReadContext readCtxt, JavaPropsSchema schema, Map<?, ?> content) {
        return new JavaPropsParser(readCtxt, this._createContext(this._createContentReference(content), true), readCtxt.getStreamReadFeatures(this._streamReadFeatures), schema, content, content);
    }

    public JavaPropsGenerator createGenerator(ObjectWriteContext writeCtxt, JavaPropsSchema schema, Map<?, ?> target) {
        if (schema == null) {
            schema = EMPTY_SCHEMA;
        }
        return new PropertiesBackedGenerator(writeCtxt, this._createContext(this._createContentReference(target), true), writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), schema, target);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        Properties props = this._loadProperties(in, ioCtxt);
        return new JavaPropsParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), this._getSchema(readCtxt), in, props);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, Reader r) {
        Properties props = this._loadProperties(r, ioCtxt);
        return new JavaPropsParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), this._getSchema(readCtxt), r, props);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, char[] data, int offset, int len, boolean recyclable) {
        return this._createParser(readCtxt, ioCtxt, new CharArrayReader(data, offset, len));
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        return this._createParser(readCtxt, ioCtxt, new Latin1Reader(data, offset, len));
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    private final JavaPropsSchema _getSchema(ObjectReadContext readCtxt) {
        FormatSchema sch = readCtxt.getSchema();
        if (sch == null) {
            return JavaPropsParser.DEFAULT_SCHEMA;
        }
        return (JavaPropsSchema)sch;
    }

    protected JsonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, Writer out) {
        return new WriterBackedGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), this._getSchema(writeCtxt), out);
    }

    protected JsonGenerator _createUTF8Generator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) {
        return new WriterBackedGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), this._getSchema(writeCtxt), this._createWriter(ioCtxt, out, null));
    }

    protected Writer _createWriter(IOContext ctioCtxtxt, OutputStream out, JsonEncoding enc) {
        try {
            return new OutputStreamWriter(out, CHARSET_ID_LATIN1);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    private final JavaPropsSchema _getSchema(ObjectWriteContext ctxt) {
        FormatSchema sch = ctxt.getSchema();
        if (sch == null) {
            return JavaPropsParser.DEFAULT_SCHEMA;
        }
        return (JavaPropsSchema)sch;
    }

    protected Properties _loadProperties(InputStream in, IOContext ctxt) {
        return this._loadProperties(new Latin1Reader(ctxt, in), ctxt);
    }

    protected Properties _loadProperties(Reader r0, IOContext ctxt) {
        Properties props;
        block10: {
            props = new Properties();
            try {
                if (ctxt.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE)) {
                    try (Reader r = r0;){
                        props.load(r);
                        break block10;
                    }
                }
                props.load(r0);
            }
            catch (IllegalArgumentException e) {
                this._reportReadException("Invalid content, problem: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
        return props;
    }

    protected <T> T _reportReadException(String msg, Exception rootCause) {
        throw new StreamReadException((JsonParser)null, msg, (Throwable)rootCause);
    }
}

