/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion.polymorphism;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.dataformat.ion.polymorphism.IonAnnotationTypeDeserializer;
import tools.jackson.dataformat.ion.polymorphism.IonAnnotationTypeSerializer;

public class IonAnnotationTypeResolverBuilder
implements TypeResolverBuilder<IonAnnotationTypeResolverBuilder> {
    private Class<?> defaultImpl;
    private TypeIdResolver typeIdResolver;
    private boolean typeIdVisible;

    protected IonAnnotationTypeResolverBuilder() {
    }

    protected IonAnnotationTypeResolverBuilder(Class<?> defaultImpl, TypeIdResolver idResolver) {
        this.defaultImpl = defaultImpl;
        this.typeIdVisible = false;
        this.typeIdResolver = idResolver;
    }

    protected IonAnnotationTypeResolverBuilder(IonAnnotationTypeResolverBuilder base, Class<?> defaultImpl) {
        this.typeIdResolver = base.typeIdResolver;
        this.typeIdVisible = base.typeIdVisible;
        this.defaultImpl = defaultImpl;
    }

    public static IonAnnotationTypeResolverBuilder construct(JavaType baseType, JsonTypeInfo.Value typeInfo, TypeIdResolver idResolver) {
        return new IonAnnotationTypeResolverBuilder(baseType.getRawClass(), idResolver);
    }

    public Class<?> getDefaultImpl() {
        return this.defaultImpl;
    }

    public TypeSerializer buildTypeSerializer(SerializationContext ctxt, JavaType baseType, Collection<NamedType> subtypes) {
        return new IonAnnotationTypeSerializer(this.typeIdResolver);
    }

    public TypeDeserializer buildTypeDeserializer(DeserializationContext ctxt, JavaType baseType, Collection<NamedType> subtypes) {
        JavaType defImplType = this.defaultImpl == null ? null : ctxt.constructSpecializedType(baseType, this.defaultImpl);
        return new IonAnnotationTypeDeserializer(baseType, this.typeIdResolver, null, this.typeIdVisible, defImplType);
    }

    public IonAnnotationTypeResolverBuilder init(JsonTypeInfo.Value settings, TypeIdResolver res) {
        if (settings != null) {
            this.defaultImpl = settings.getDefaultImpl();
            this.typeIdVisible = settings.getIdVisible();
        }
        if (res != null) {
            this.typeIdResolver = res;
        }
        return this;
    }

    public IonAnnotationTypeResolverBuilder withDefaultImpl(Class<?> newDefaultImpl) {
        if (newDefaultImpl == this.defaultImpl) {
            return this;
        }
        return new IonAnnotationTypeResolverBuilder(this, this.defaultImpl);
    }

    public IonAnnotationTypeResolverBuilder withSettings(JsonTypeInfo.Value settings) {
        this.defaultImpl = settings.getDefaultImpl();
        this.typeIdVisible = settings.getIdVisible();
        return this;
    }
}

