/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion.ionvalue;

import com.amazon.ion.IonContainer;
import com.amazon.ion.IonValue;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.dataformat.ion.ionvalue.IonValueDeserializer;

class DeserializersEx
extends SimpleDeserializers {
    private static final long serialVersionUID = 1L;
    private static final IonValueDeserializer ION_VALUE_DESERIALIZER = new IonValueDeserializer();

    DeserializersEx() {
    }

    public ValueDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef) {
        if (IonValue.class.isAssignableFrom(type.getRawClass())) {
            return ION_VALUE_DESERIALIZER;
        }
        return super.findBeanDeserializer(type, config, beanDescRef);
    }

    public ValueDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription.Supplier beanDescRef, TypeDeserializer elementTypeDeserializer, ValueDeserializer<?> elementDeserializer) {
        if (IonContainer.class.isAssignableFrom(type.getRawClass())) {
            return ION_VALUE_DESERIALIZER;
        }
        return super.findCollectionDeserializer(type, config, beanDescRef, elementTypeDeserializer, elementDeserializer);
    }
}

