/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.csv;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamWriteContext;
import tools.jackson.dataformat.csv.CsvCharacterEscapes;
import tools.jackson.dataformat.csv.CsvSchema;
import tools.jackson.dataformat.csv.CsvValueDecorator;
import tools.jackson.dataformat.csv.CsvWriteException;
import tools.jackson.dataformat.csv.CsvWriteFeature;
import tools.jackson.dataformat.csv.PackageVersion;
import tools.jackson.dataformat.csv.impl.CsvEncoder;

public class CsvGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected final int _formatFeatures;
    protected final CsvSchema _schema;
    protected CsvEncoder _writer;
    protected SimpleStreamWriteContext _streamWriteContext;
    protected boolean _handleFirstLine = true;
    protected int _nextColumnByName = -1;
    protected CsvValueDecorator _nextColumnDecorator;
    protected boolean _skipValue;
    protected String _arraySeparator = "";
    protected StringBuilder _arrayContents;
    protected int _arrayElements;
    protected SimpleStreamWriteContext _skipWithin;

    public CsvGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int csvFeatures, Writer out, CsvSchema schema, CsvCharacterEscapes characterEscapes) {
        super(writeCtxt, ioCtxt, streamWriteFeatures);
        this._formatFeatures = csvFeatures;
        DupDetector dups = StreamWriteFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamWriteFeatures) ? DupDetector.rootDetector((JsonGenerator)this) : null;
        this._streamWriteContext = SimpleStreamWriteContext.createRootContext((DupDetector)dups);
        this._schema = schema;
        if (characterEscapes == null) {
            characterEscapes = CsvCharacterEscapes.fromCsvFeatures(csvFeatures);
        }
        boolean useFastDoubleWriter = this.isEnabled(StreamWriteFeature.USE_FAST_DOUBLE_WRITER);
        this._writer = new CsvEncoder(ioCtxt, csvFeatures, out, schema, characterEscapes, useFastDoubleWriter);
    }

    public CsvGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int csvFeatures, CsvEncoder csvWriter) {
        super(writeCtxt, ioCtxt, streamWriteFeatures);
        this._formatFeatures = csvFeatures;
        DupDetector dups = StreamWriteFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamWriteFeatures) ? DupDetector.rootDetector((JsonGenerator)this) : null;
        this._streamWriteContext = SimpleStreamWriteContext.createRootContext((DupDetector)dups);
        this._schema = EMPTY_SCHEMA;
        this._writer = csvWriter;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public final Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public final void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    public Object streamWriteOutputTarget() {
        return this._writer.getOutputTarget();
    }

    public int streamWriteOutputBuffered() {
        return this._writer.getOutputBuffered();
    }

    public CsvGenerator setCharacterEscapes(CharacterEscapes esc) {
        if (esc != null) {
            this._writer.setOutputEscapes(esc.getEscapeCodesForAscii());
        }
        return this;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public PrettyPrinter getPrettyPrinter() {
        return null;
    }

    public boolean canOmitProperties() {
        return false;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    public JsonGenerator writeName(String name) throws JacksonException {
        if (!this._streamWriteContext.writeName(name)) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        this._writeFieldName(name);
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        return this.writeName(Long.toString(id));
    }

    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        if (!this._streamWriteContext.writeName(name.getValue())) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        this._writeFieldName(name.getValue());
        return this;
    }

    private final void _writeFieldName(String name) throws JacksonException {
        if (this._schema == null) {
            this._reportCsvWriteError("Unrecognized column '" + name + "', can not resolve without CsvSchema");
        }
        if (this._skipWithin != null) {
            this._skipValue = true;
            this._nextColumnByName = -1;
            this._nextColumnDecorator = null;
            return;
        }
        CsvSchema.Column col = this._schema.column(name, this._nextColumnByName + 1);
        if (col == null) {
            this._nextColumnByName = -1;
            this._nextColumnDecorator = null;
            if (this.isEnabled(StreamWriteFeature.IGNORE_UNKNOWN)) {
                this._skipValue = true;
                return;
            }
            this._reportCsvWriteError("Unrecognized column '" + name + "': known columns: " + this._schema.getColumnDesc());
        }
        this._skipValue = false;
        this._nextColumnByName = col.getIndex();
        this._nextColumnDecorator = col.getValueDecorator();
    }

    public final boolean isEnabled(CsvWriteFeature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public final void flush() {
        try {
            this._writer.flush(this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM));
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    public void close() {
        if (!this.isClosed()) {
            this.finishRow();
            if (this._handleFirstLine) {
                this._handleFirstLine();
            }
        }
        super.close();
    }

    protected void _closeInput() throws IOException {
        this._writer.close(this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET), this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM));
    }

    public JsonGenerator writeStartArray() throws JacksonException {
        this._verifyValueWrite("start an array");
        if (this._streamWriteContext.inObject()) {
            if (this._skipWithin == null && this._skipValue && this.isEnabled(StreamWriteFeature.IGNORE_UNKNOWN)) {
                this._skipWithin = this._streamWriteContext;
            } else if (!this._skipValue) {
                CsvSchema.Column col;
                String sep = this._nextColumnByName >= 0 ? ((col = this._schema.column(this._nextColumnByName)).isArray() ? col.getArrayElementSeparator() : "") : "";
                if (sep.isEmpty()) {
                    if (!this._schema.hasArrayElementSeparator()) {
                        this._reportError("CSV generator does not support Array values for properties without setting 'arrayElementSeparator' in schema");
                    }
                    sep = this._schema.getArrayElementSeparator();
                }
                this._arraySeparator = sep;
                if (this._arrayContents == null) {
                    this._arrayContents = new StringBuilder();
                } else {
                    this._arrayContents.setLength(0);
                }
                this._arrayElements = 0;
            }
        } else if (!this._arraySeparator.isEmpty()) {
            this._reportError("CSV generator does not support nested Array values");
        }
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this.writeStartArray();
        this.assignCurrentValue(currValue);
        return this;
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        if (this._skipWithin != null) {
            if (this._streamWriteContext == this._skipWithin) {
                this._skipWithin = null;
            }
            return this;
        }
        if (!this._arraySeparator.isEmpty()) {
            String value = this._arrayContents.toString();
            if (this._nextColumnDecorator != null) {
                value = this._nextColumnDecorator.decorateValue(this, value);
            }
            this._arraySeparator = "";
            this._writer.write(this._columnIndex(), value);
        }
        if (!this._streamWriteContext.inObject()) {
            this.finishRow();
        }
        return this;
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        this._verifyValueWrite("start an object");
        if ((this._streamWriteContext.inObject() || this._streamWriteContext.inArray() && !this._streamWriteContext.getParent().inRoot()) && this._skipWithin == null) {
            if (this._skipValue && this.isEnabled(StreamWriteFeature.IGNORE_UNKNOWN)) {
                this._skipWithin = this._streamWriteContext;
            } else {
                this._reportCsvWriteError("CSV generator does not support Object values for properties (nested Objects)");
            }
        }
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        return this;
    }

    public JsonGenerator writeStartObject(Object currValue) throws JacksonException {
        this.writeStartObject();
        this.assignCurrentValue(currValue);
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        if (this._skipWithin != null) {
            if (this._streamWriteContext == this._skipWithin) {
                this._skipWithin = null;
            }
            return this;
        }
        this.finishRow();
        return this;
    }

    public JsonGenerator writeString(String text) throws JacksonException {
        if (text == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(text);
            } else {
                if (this._nextColumnDecorator != null) {
                    text = this._nextColumnDecorator.decorateValue(this, text);
                }
                this._writer.write(this._columnIndex(), text);
            }
        }
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(new String(text, offset, len));
            } else if (this._nextColumnDecorator != null) {
                String str = new String(text, offset, len);
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, str));
            } else {
                this._writer.write(this._columnIndex(), text, offset, len);
            }
        }
        return this;
    }

    public JsonGenerator writeString(SerializableString sstr) throws JacksonException {
        this._verifyValueWrite("write String value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(sstr.getValue());
            } else {
                String text = sstr.getValue();
                if (this._nextColumnDecorator != null) {
                    text = this._nextColumnDecorator.decorateValue(this, text);
                }
                this._writer.write(this._columnIndex(), text);
            }
        }
        return this;
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return this.writeString(new String(text, offset, len, StandardCharsets.UTF_8));
    }

    public JsonGenerator writeRaw(String text) throws JacksonException {
        this._writer.writeRaw(text);
        return this;
    }

    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        this._writer.writeRaw(text, offset, len);
        return this;
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        this._writer.writeRaw(text, offset, len);
        return this;
    }

    public JsonGenerator writeRaw(char c) throws JacksonException {
        this._writer.writeRaw(c);
        return this;
    }

    public JsonGenerator writeRawValue(String text) throws JacksonException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), text);
        }
        return this;
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), text.substring(offset, offset + len));
        }
        return this;
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write Raw value");
        if (!this._skipValue) {
            this._writer.writeNonEscaped(this._columnIndex(), new String(text, offset, len));
        }
        return this;
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (data == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write Binary value");
        if (!this._skipValue) {
            if (offset > 0 || offset + len != data.length) {
                data = Arrays.copyOfRange(data, offset, offset + len);
            }
            String encoded = b64variant.encode(data);
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(encoded);
            } else {
                if (this._nextColumnDecorator != null) {
                    encoded = this._nextColumnDecorator.decorateValue(this, encoded);
                }
                this._writer.write(this._columnIndex(), encoded);
            }
        }
        return this;
    }

    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        this._verifyValueWrite("write boolean value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(state ? "true" : "false");
            } else if (this._nextColumnDecorator != null) {
                String text = this._nextColumnDecorator.decorateValue(this, state ? "true" : "false");
                this._writer.write(this._columnIndex(), text);
            } else {
                this._writer.write(this._columnIndex(), state);
            }
        }
        return this;
    }

    public JsonGenerator writeNull() throws JacksonException {
        this._verifyValueWrite("write null value");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(this._schema.getNullValueOrEmpty());
            } else if (this._streamWriteContext.inObject()) {
                String nvl;
                if (this._nextColumnDecorator != null && (nvl = this._nextColumnDecorator.decorateNull(this)) != null) {
                    this._writer.write(this._columnIndex(), nvl);
                    return this;
                }
                this._writer.writeNull(this._columnIndex());
            } else if (this._streamWriteContext.inArray() && !this._streamWriteContext.getParent().inRoot()) {
                String nvl;
                if (this._nextColumnDecorator != null && (nvl = this._nextColumnDecorator.decorateNull(this)) != null) {
                    this._writer.write(this._columnIndex(), nvl);
                    return this;
                }
                this._writer.writeNull(this._columnIndex());
            }
        }
        return this;
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        return this.writeNumber((int)v);
    }

    public JsonGenerator writeNumber(int v) throws JacksonException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else if (this._nextColumnDecorator != null) {
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, String.valueOf(v)));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
        return this;
    }

    public JsonGenerator writeNumber(long v) throws JacksonException {
        if (v <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE) {
            return this.writeNumber((int)v);
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else if (this._nextColumnDecorator != null) {
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, String.valueOf(v)));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
        return this;
    }

    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else if (this._nextColumnDecorator != null) {
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, String.valueOf(v)));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
        return this;
    }

    public JsonGenerator writeNumber(double v) throws JacksonException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else if (this._nextColumnDecorator != null) {
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, String.valueOf(v)));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
        return this;
    }

    public JsonGenerator writeNumber(float v) throws JacksonException {
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(String.valueOf(v));
            } else if (this._nextColumnDecorator != null) {
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, String.valueOf(v)));
            } else {
                this._writer.write(this._columnIndex(), v);
            }
        }
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            boolean plain = this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN);
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(plain ? v.toPlainString() : v.toString());
            } else if (this._nextColumnDecorator != null) {
                String numStr = plain ? v.toPlainString() : v.toString();
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, numStr));
            } else {
                this._writer.write(this._columnIndex(), v, plain);
            }
        }
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        if (encodedValue == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        if (!this._skipValue) {
            if (!this._arraySeparator.isEmpty()) {
                this._addToArray(encodedValue);
            } else if (this._nextColumnDecorator != null) {
                this._writer.write(this._columnIndex(), this._nextColumnDecorator.decorateValue(this, encodedValue));
            } else {
                this._writer.write(this._columnIndex(), encodedValue);
            }
        }
        return this;
    }

    public JsonGenerator writeOmittedProperty(String propName) throws JacksonException {
        CsvSchema.Column col = this._schema.column(propName);
        if (col != null) {
            if (!this._streamWriteContext.writeName(propName)) {
                this._reportError("Cannot skip a property, expecting a value");
            }
            this._nextColumnByName = col.getIndex();
            this._verifyValueWrite("skip positional value due to filtering");
            this._writer.write(this._columnIndex(), "");
        }
        return this;
    }

    protected final void _verifyValueWrite(String typeMsg) throws JacksonException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Cannot " + typeMsg + ", expecting a property name");
        }
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
    }

    protected void _releaseBuffers() {
        this._writer._releaseBuffers();
    }

    protected void _reportCsvWriteError(String msg) throws JacksonException {
        throw CsvWriteException.from(this, msg, this._schema);
    }

    protected final int _columnIndex() {
        int ix = this._nextColumnByName;
        if (ix < 0) {
            ix = this._writer.nextColumnIndex();
        }
        return ix;
    }

    protected void finishRow() throws JacksonException {
        this._writer.endRow();
        this._nextColumnByName = -1;
    }

    protected void _handleFirstLine() throws JacksonException {
        this._handleFirstLine = false;
        if (this._schema.usesHeader()) {
            int count = this._schema.size();
            if (count == 0) {
                this._reportCsvWriteError("Schema specified that header line is to be written; but contains no column names");
            }
            for (CsvSchema.Column column : this._schema) {
                this._writer.writeColumnName(column.getName());
            }
            this._writer.endRow();
        }
    }

    protected void _addToArray(String value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append(this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }

    protected void _addToArray(char[] value) {
        if (this._arrayElements > 0) {
            this._arrayContents.append(this._arraySeparator);
        }
        ++this._arrayElements;
        this._arrayContents.append(value);
    }
}

