/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.csv;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.ser.SerializationContextExt;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.databind.util.SimpleLookupCache;
import tools.jackson.databind.util.ViewMatcher;
import tools.jackson.dataformat.csv.CsvFactory;
import tools.jackson.dataformat.csv.CsvReadFeature;
import tools.jackson.dataformat.csv.CsvSchema;
import tools.jackson.dataformat.csv.CsvWriteFeature;

public class CsvMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected final SimpleLookupCache<ViewKey, CsvSchema> _untypedSchemas = new SimpleLookupCache(8, 32);
    protected final SimpleLookupCache<ViewKey, CsvSchema> _typedSchemas = new SimpleLookupCache(8, 32);

    public CsvMapper() {
        this(new Builder(new CsvFactory()));
    }

    public CsvMapper(CsvFactory f) {
        this(new Builder(f));
    }

    public CsvMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new CsvFactory());
    }

    public static Builder builder(CsvFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static CsvMapper shared() {
        return SharedWrapper.wrapped();
    }

    protected Object writeReplace() {
        return this._savedBuilderState;
    }

    protected Object readResolve() {
        throw new IllegalStateException("Should never deserialize `" + ((Object)((Object)this)).getClass().getName() + "` directly");
    }

    public CsvFactory tokenStreamFactory() {
        return (CsvFactory)this._streamFactory;
    }

    public ObjectReader readerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with((FormatSchema)this.schemaFor(type));
    }

    public ObjectReader readerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with((FormatSchema)this.typedSchemaFor(type));
    }

    public ObjectWriter writerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with((FormatSchema)this.schemaFor(type));
    }

    public ObjectWriter writerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with((FormatSchema)this.typedSchemaFor(type));
    }

    public CsvSchema schemaWithHeader() {
        return CsvSchema.emptySchema().withHeader();
    }

    public CsvSchema schema() {
        return CsvSchema.emptySchema();
    }

    public CsvSchema schemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._untypedSchemas, false, null);
    }

    public CsvSchema schemaForWithView(JavaType pojoType, Class<?> view) {
        return this._schemaFor(pojoType, this._untypedSchemas, false, view);
    }

    public final CsvSchema schemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false, null);
    }

    public final CsvSchema schemaForWithView(Class<?> pojoType, Class<?> view) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false, view);
    }

    public final CsvSchema schemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false, null);
    }

    public final CsvSchema schemaForWithView(TypeReference<?> pojoTypeRef, Class<?> view) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false, view);
    }

    public CsvSchema typedSchemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._typedSchemas, true, null);
    }

    public CsvSchema typedSchemaForWithView(JavaType pojoType, Class<?> view) {
        return this._schemaFor(pojoType, this._typedSchemas, true, view);
    }

    public final CsvSchema typedSchemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true, null);
    }

    public final CsvSchema typedSchemaForWithView(Class<?> pojoType, Class<?> view) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true, view);
    }

    public final CsvSchema typedSchemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true, null);
    }

    public final CsvSchema typedSchemaForWithView(TypeReference<?> pojoTypeRef, Class<?> view) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true, view);
    }

    protected CsvSchema _schemaFor(JavaType pojoType, SimpleLookupCache<ViewKey, CsvSchema> schemas, boolean typed, Class<?> view) {
        ViewKey viewKey = new ViewKey(pojoType, view);
        CsvSchema s = (CsvSchema)schemas.get((Object)viewKey);
        if (s != null) {
            return s;
        }
        SerializationContextExt ctxt = this._serializationContext();
        CsvSchema.Builder builder = CsvSchema.builder();
        this._addSchemaProperties((SerializationContext)ctxt, builder, typed, pojoType, null, view);
        CsvSchema result = builder.build();
        schemas.put((Object)viewKey, (Object)result);
        return result;
    }

    protected boolean _nonPojoType(JavaType t) {
        if (t.isPrimitive() || t.isEnumType()) {
            return true;
        }
        Class raw = t.getRawClass();
        if (Number.class.isAssignableFrom(raw) && (raw == Byte.class || raw == Short.class || raw == Character.class || raw == Integer.class || raw == Long.class || raw == Float.class || raw == Double.class)) {
            return true;
        }
        return raw == Boolean.class || raw == String.class;
    }

    protected void _addSchemaProperties(SerializationContext ctxt, CsvSchema.Builder builder, boolean typed, JavaType pojoType, NameTransformer unwrapper, Class<?> view) {
        if (this._nonPojoType(pojoType)) {
            return;
        }
        BeanDescription beanDesc = ctxt.introspectBeanDescription(pojoType);
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        boolean includeByDefault = this.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        for (BeanPropertyDefinition prop : beanDesc.findProperties()) {
            NameTransformer nextUnwrapper;
            if (view != null) {
                Class[] views = prop.findViews();
                if (views == null) {
                    views = beanDesc.findDefaultViews();
                }
                if ((views != null || !includeByDefault) && !ViewMatcher.construct((Class[])views).isVisibleForView(view)) continue;
            }
            if (!prop.couldSerialize()) continue;
            AnnotatedMember m = prop.getPrimaryMember();
            if (m != null && (nextUnwrapper = intr.findUnwrappingNameTransformer((MapperConfig)ctxt.getConfig(), prop.getPrimaryMember())) != null) {
                if (unwrapper != null) {
                    nextUnwrapper = NameTransformer.chainedTransformer((NameTransformer)unwrapper, (NameTransformer)nextUnwrapper);
                }
                JavaType nextType = m.getType();
                this._addSchemaProperties(ctxt, builder, typed, nextType, nextUnwrapper, view);
                continue;
            }
            String name = prop.getName();
            if (unwrapper != null) {
                name = unwrapper.transform(name);
            }
            if (typed && m != null) {
                builder.addColumn(name, this._determineType(m.getRawType()));
                continue;
            }
            builder.addColumn(name);
        }
    }

    protected CsvSchema.ColumnType _determineType(Class<?> propType) {
        if (propType.isArray()) {
            if (propType == byte[].class) {
                return CsvSchema.ColumnType.STRING;
            }
            return CsvSchema.ColumnType.ARRAY;
        }
        if (propType == String.class || propType == Character.TYPE || propType == Character.class) {
            return CsvSchema.ColumnType.STRING;
        }
        if (propType == Boolean.class || propType == Boolean.TYPE) {
            return CsvSchema.ColumnType.BOOLEAN;
        }
        if (propType.isPrimitive()) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Number.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Collection.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.ARRAY;
        }
        return CsvSchema.ColumnType.NUMBER_OR_STRING;
    }

    public static class Builder
    extends MapperBuilder<CsvMapper, Builder> {
        public Builder(CsvFactory f) {
            super((TokenStreamFactory)f);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public CsvMapper build() {
            return new CsvMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(CsvReadFeature ... features) {
            for (CsvReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(CsvReadFeature ... features) {
            for (CsvReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(CsvReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(CsvWriteFeature ... features) {
            for (CsvWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(CsvWriteFeature ... features) {
            for (CsvWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(CsvWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final CsvMapper MAPPER = CsvMapper.builder().build();

        private SharedWrapper() {
        }

        public static CsvMapper wrapped() {
            return MAPPER;
        }
    }

    public static final class ViewKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JavaType _pojoType;
        private final Class<?> _view;
        private final int _hashCode;

        public ViewKey(JavaType pojoType, Class<?> view) {
            this._pojoType = pojoType;
            this._view = view;
            this._hashCode = Objects.hash(pojoType, view);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ViewKey other = (ViewKey)o;
            if (this._hashCode != other._hashCode || this._view != other._view) {
                return false;
            }
            return Objects.equals(this._pojoType, other._pojoType);
        }

        public String toString() {
            String viewName = this._view != null ? this._view.getName() : null;
            return "[ViewKey: pojoType=" + String.valueOf(this._pojoType) + ", view=" + viewName + "]";
        }
    }
}

