/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.schema;

import java.time.temporal.Temporal;
import java.util.UUID;
import org.apache.avro.Schema;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.dataformat.avro.AvroSchema;
import tools.jackson.dataformat.avro.schema.ArrayVisitor;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.schema.DateTimeVisitor;
import tools.jackson.dataformat.avro.schema.DefinedSchemas;
import tools.jackson.dataformat.avro.schema.DoubleVisitor;
import tools.jackson.dataformat.avro.schema.EnumVisitor;
import tools.jackson.dataformat.avro.schema.IntegerVisitor;
import tools.jackson.dataformat.avro.schema.MapVisitor;
import tools.jackson.dataformat.avro.schema.RecordVisitor;
import tools.jackson.dataformat.avro.schema.SchemaBuilder;
import tools.jackson.dataformat.avro.schema.StringVisitor;
import tools.jackson.dataformat.avro.schema.UUIDVisitor;

public class VisitorFormatWrapperImpl
implements JsonFormatVisitorWrapper {
    public static final boolean DEFAULT_LOGICAL_TYPES_ENABLED = true;
    public static final boolean DEFAULT_ENUM_AS_STRING = false;
    protected SerializationContext _context;
    protected final DefinedSchemas _schemas;
    protected boolean _logicalTypesEnabled = true;
    protected boolean _writeEnumAsString = false;
    protected SchemaBuilder _builder;
    protected Schema _valueSchema;

    public VisitorFormatWrapperImpl(DefinedSchemas schemas, SerializationContext ctxt) {
        this._schemas = schemas;
        this._context = ctxt;
    }

    protected VisitorFormatWrapperImpl(VisitorFormatWrapperImpl src) {
        this._schemas = src._schemas;
        this._context = src._context;
        this._logicalTypesEnabled = src._logicalTypesEnabled;
        this._writeEnumAsString = src._writeEnumAsString;
    }

    protected VisitorFormatWrapperImpl createChildWrapper() {
        return new VisitorFormatWrapperImpl(this);
    }

    public SerializationContext getContext() {
        return this._context;
    }

    public void setContext(SerializationContext ctxt) {
        this._schemas.setContext(ctxt);
        this._context = ctxt;
    }

    protected DefinedSchemas getSchemas() {
        return this._schemas;
    }

    public Schema getAvroSchema() {
        if (this._valueSchema != null) {
            return this._valueSchema;
        }
        if (this._builder == null) {
            throw new IllegalStateException("No visit methods called on " + this.getClass().getName() + ": no schema generated");
        }
        return this._builder.builtAvroSchema();
    }

    public VisitorFormatWrapperImpl enableLogicalTypes() {
        this._logicalTypesEnabled = true;
        return this;
    }

    public VisitorFormatWrapperImpl disableLogicalTypes() {
        this._logicalTypesEnabled = false;
        return this;
    }

    public boolean isLogicalTypesEnabled() {
        return this._logicalTypesEnabled;
    }

    public VisitorFormatWrapperImpl enableWriteEnumAsString() {
        this._writeEnumAsString = true;
        return this;
    }

    public VisitorFormatWrapperImpl disableWriteEnumAsString() {
        this._writeEnumAsString = false;
        return this;
    }

    public boolean isWriteEnumAsStringEnabled() {
        return this._writeEnumAsString;
    }

    public void expectAvroFormat(AvroSchema schema) {
        this._valueSchema = schema.getAvroSchema();
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) {
        Schema s = this._schemas.findSchema(type);
        if (s != null) {
            this._valueSchema = s;
            return null;
        }
        RecordVisitor v = new RecordVisitor(this._context, type, this);
        this._builder = v;
        return v;
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType mapType) {
        MapVisitor v = new MapVisitor(this._context, mapType, this);
        this._builder = v;
        return v;
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        JavaType vt;
        if (convertedType.isArrayType() && (vt = convertedType.getContentType()).hasRawClass(Byte.TYPE)) {
            this._builder = () -> AvroSchemaHelper.typedSchema(Schema.Type.BYTES, convertedType);
            return null;
        }
        ArrayVisitor v = new ArrayVisitor(this._context, convertedType, this);
        this._builder = v;
        return v;
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) {
        Schema s = this._schemas.findSchema(type);
        if (s != null) {
            this._valueSchema = s;
            return null;
        }
        if (type.isEnumType() && !this.isWriteEnumAsStringEnabled()) {
            EnumVisitor v = new EnumVisitor(this._context, this._schemas, type);
            this._builder = v;
            return v;
        }
        if (type.hasRawClass(UUID.class)) {
            UUIDVisitor v = new UUIDVisitor(this._logicalTypesEnabled);
            this._builder = v;
            return v;
        }
        StringVisitor v = new StringVisitor(this._context, type);
        this._builder = v;
        return v;
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType convertedType) {
        DoubleVisitor v = new DoubleVisitor(convertedType);
        this._builder = v;
        return v;
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) {
        Schema s = this._schemas.findSchema(type);
        if (s != null) {
            this._valueSchema = s;
            return null;
        }
        if (this.isLogicalTypesEnabled() && this._isDateTimeType(type)) {
            DateTimeVisitor v = new DateTimeVisitor(type);
            this._builder = v;
            return v;
        }
        IntegerVisitor v = new IntegerVisitor(type);
        this._builder = v;
        return v;
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        this._valueSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        return null;
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType convertedType) {
        this._valueSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        return null;
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType convertedType) {
        String msg = "\"Any\" type (usually for `java.lang.Object`) not supported: `expectAnyFormat` called with type " + String.valueOf(convertedType);
        throw InvalidDefinitionException.from((JsonGenerator)null, (String)msg, (JavaType)convertedType);
    }

    protected <T> T _throwUnsupported() {
        return this._throwUnsupported("Format variation not supported");
    }

    protected <T> T _throwUnsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    private boolean _isDateTimeType(JavaType type) {
        return Temporal.class.isAssignableFrom(type.getRawClass());
    }
}

