/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import tools.jackson.core.FormatFeature;

public enum AvroWriteFeature implements FormatFeature
{
    AVRO_BUFFERING(true),
    AVRO_FILE_OUTPUT(false),
    ADD_NULL_AS_DEFAULT_VALUE_IN_SCHEMA(false);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (AvroWriteFeature f : AvroWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private AvroWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public int getMask() {
        return this._mask;
    }

    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }
}

