/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.jsr310.ser;

import java.time.LocalTime;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import tools.jackson.databind.ser.std.StdScalarSerializer;

public class AvroLocalTimeSerializer
extends StdScalarSerializer<LocalTime> {
    public static final AvroLocalTimeSerializer INSTANCE = new AvroLocalTimeSerializer();

    protected AvroLocalTimeSerializer() {
        super(LocalTime.class);
    }

    public void serialize(LocalTime value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        long milliOfDay = value.toNanoOfDay() / 1000000L;
        gen.writeNumber(milliOfDay);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JacksonException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.INT);
        }
    }
}

