/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.ser;

import org.apache.avro.reflect.CustomEncoding;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.dataformat.avro.AvroSchema;
import tools.jackson.dataformat.avro.CustomEncodingWrapper;
import tools.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import tools.jackson.dataformat.avro.ser.CustomEncodingDatum;

public class CustomEncodingSerializer<T>
extends ValueSerializer<T> {
    private final CustomEncodingWrapper<T> encoding;

    public CustomEncodingSerializer(CustomEncoding<T> encoding) {
        this.encoding = new CustomEncodingWrapper<T>(encoding);
    }

    public void serialize(T t, JsonGenerator jsonGenerator, SerializationContext ctxt) throws JacksonException {
        jsonGenerator.writeEmbeddedObject(new CustomEncodingDatum<T>(this.encoding, t));
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType type) {
        if (visitor instanceof VisitorFormatWrapperImpl) {
            ((VisitorFormatWrapperImpl)visitor).expectAvroFormat(new AvroSchema(this.encoding.getSchema()));
        } else {
            super.acceptJsonFormatVisitor(visitor, type);
        }
    }
}

