/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.importer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import tools.dynamia.modules.importer.ImportUtils;

public class ImportExcelTemplate {
    private File excelTemplate;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public ImportExcelTemplate(File excelTemplate) {
        this.excelTemplate = excelTemplate;
    }

    public void addVar(String cellName, Object value) {
        this.variables.put(cellName, value);
    }

    public void addVars(Map<String, Object> vars) {
        this.variables.putAll(vars);
    }

    public File parse(String outputname) throws IOException {
        Workbook workbook = WorkbookFactory.create((File)this.excelTemplate);
        Sheet sheet = workbook.getSheetAt(0);
        this.variables.forEach((k, v) -> {
            Cell cell = ImportUtils.findCellByCoordinate(sheet, k);
            ImportUtils.setCellValue(cell, v);
        });
        File outfile = File.createTempFile(outputname, ".xlsx");
        workbook.write((OutputStream)new FileOutputStream(outfile));
        workbook.close();
        return outfile;
    }
}

