/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.boteco.persistence.user;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tools.devnull.boteco.Destination;
import tools.devnull.boteco.InvalidDestinationException;
import tools.devnull.boteco.MessageLocation;
import tools.devnull.boteco.user.User;

public class BotecoUser
implements User {
    private static final long serialVersionUID = 7185963234889976203L;
    @SerializedName(value="_id")
    private final String id;
    private final Map<String, String> destinations;
    private String primaryDestination;

    public BotecoUser(String id, MessageLocation primaryDestination) {
        this.id = id;
        this.primaryDestination = primaryDestination.channel();
        this.destinations = new HashMap<String, String>();
        this.destinations.put(primaryDestination.channel(), primaryDestination.target());
    }

    public String id() {
        return this.id;
    }

    public List<MessageLocation> destinations() {
        return this.destinations.entrySet().stream().map(entry -> (MessageLocation)Destination.channel((String)((String)entry.getKey())).to(entry.getValue())).collect(Collectors.toList());
    }

    public MessageLocation primaryDestination() {
        return (MessageLocation)Destination.channel((String)this.primaryDestination).to((Object)this.destinations.get(this.primaryDestination));
    }

    public MessageLocation destination(String channel) {
        if (this.destinations.containsKey(channel)) {
            return (MessageLocation)Destination.channel((String)channel).to((Object)this.destinations.get(channel));
        }
        throw new InvalidDestinationException("User don't have the channel '" + channel + "' registered");
    }

    public void addDestination(MessageLocation destination) {
        this.destinations.put(destination.channel(), destination.target());
    }

    public void removeDestination(MessageLocation destination) {
        if (destination.channel().equals(this.primaryDestination)) {
            throw new InvalidDestinationException("Can't remove default destination");
        }
        if (!this.destinations.containsKey(destination.channel())) {
            throw new InvalidDestinationException("User don't have the given destination");
        }
        this.destinations.remove(destination.channel());
    }

    public void removeDestination(String channel) throws InvalidDestinationException {
        this.removeDestination(this.destination(channel));
    }

    public void setPrimaryDestination(MessageLocation primaryDestination) {
        this.addDestination(primaryDestination);
        this.primaryDestination = primaryDestination.channel();
    }

    public void setPrimaryDestination(String channel) {
        if (!this.destinations.containsKey(channel)) {
            throw new InvalidDestinationException("User don't have the channel " + channel + " linked");
        }
        this.primaryDestination = channel;
    }
}

