/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.file;

import com.alexbarter.lib.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import tools.cipher.lib.fitness.TextFitness;

public class FileReader {
    public static void read(File file, Consumer<String> action) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName() + " (No such file)");
        }
        FileInputStream fIn = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(fIn));
        FileReader.read(reader, action);
    }

    public static void read(String resourcePath, Consumer<String> action) throws FileNotFoundException, IOException {
        InputStream inputStream = TextFitness.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new FileNotFoundException(resourcePath + " (No such resource)");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        FileReader.read(reader, action);
    }

    public static void read(BufferedReader reader, Consumer<String> action) throws IOException {
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                action.accept(line);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Utils.tryClose((Object[])new BufferedReader[]{reader});
                throw throwable;
            }
            Utils.tryClose((Object[])new BufferedReader[]{reader});
        }
        Utils.tryClose((Object[])new BufferedReader[]{reader});
    }

    @Deprecated
    public static void compileTextFromFile(String filePath, Consumer<String> action) {
        try {
            FileReader.read(new File(filePath), action);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void readLinesFromFile(File file, Consumer<String> action) {
        try {
            FileReader.read(file, action);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void compileTextFromResource(String resourcePath, Consumer<String> action) {
        try {
            FileReader.read(resourcePath, action);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void readLinesFromBufferedReader(BufferedReader reader, Consumer<String> action) {
        try {
            FileReader.read(reader, action);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

