/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.math;

import tools.cipher.lib.math.SimultaneousEquationExpection;
import tools.cipher.lib.matrix.Matrix;
import tools.cipher.lib.matrix.MatrixNoInverse;

public class SimultaneousEquations {
    public static Integer[] solve(Integer[][] simEquations, int mod) throws SimultaneousEquationExpection {
        int UNKNOWNS = simEquations.length;
        Matrix matrix = new Matrix((r, c) -> simEquations[r][c], UNKNOWNS, UNKNOWNS);
        Matrix invMatrix = null;
        try {
            invMatrix = matrix.inverseMod(mod);
        }
        catch (MatrixNoInverse e) {
            throw new SimultaneousEquationExpection("No exact solution to simulation equations");
        }
        Matrix equalsMatrix = new Matrix((r, c) -> simEquations[r][UNKNOWNS], UNKNOWNS, 1);
        return invMatrix.multiply((Matrix)equalsMatrix).modular((int)mod).data;
    }

    private static Integer[] solve(Integer[][] simEquations) throws SimultaneousEquationExpection {
        int UNKNOWNS = simEquations.length;
        Matrix matrix = new Matrix((r, c) -> simEquations[r][c], UNKNOWNS, UNKNOWNS);
        Matrix invMatrix = null;
        try {
            invMatrix = matrix.inverse();
        }
        catch (MatrixNoInverse e) {
            throw new SimultaneousEquationExpection("No exact solution to simulation equations");
        }
        Matrix equalsMatrix = new Matrix((r, c) -> simEquations[r][UNKNOWNS], UNKNOWNS, 1);
        return invMatrix.multiply((Matrix)equalsMatrix).data;
    }
}

