/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.fitness;

import com.alexbarter.ciphertool.lib.characters.CharacterCount;
import com.alexbarter.ciphertool.lib.language.ILanguage;
import com.alexbarter.lib.util.MathUtil;
import java.util.Map;

public class ChiSquared {
    public static double calculate(CharSequence text, ILanguage language) {
        return ChiSquared.calculate(CharacterCount.getCount(text), text.length(), language);
    }

    public static double calculate(char[] text, ILanguage language) {
        return ChiSquared.calculate(CharacterCount.getCount(text), text.length, language);
    }

    public static double calculate(Map<Character, Integer> letters, int length, ILanguage language) {
        if (length == -1) {
            length = MathUtil.sumAsInt(letters.values());
        }
        double total = 0.0;
        for (char letter : language.getLetterFrequency().keySet()) {
            double count = letters.getOrDefault(Character.valueOf(letter), 0).intValue();
            double expectedCount = language.getFrequencyOfLetter(letter) * (double)length / 100.0;
            double sum = Math.pow(count - expectedCount, 2.0) / expectedCount;
            total += sum;
        }
        return total;
    }
}

