/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.language;

import com.alexbarter.ciphertool.lib.fitness.NGramData;
import com.alexbarter.ciphertool.lib.fitness.TextFitness;
import com.alexbarter.ciphertool.lib.language.ILanguage;
import java.util.Map;

public class English
extends ILanguage {
    private NGramData quadgramData;
    private NGramData trigramData;
    private NGramData bigramData;

    protected English() {
    }

    @Override
    public Map<Character, Double> addLetterFrequencies(Map<Character, Double> freqMap) {
        freqMap.put(Character.valueOf('A'), 8.167);
        freqMap.put(Character.valueOf('B'), 1.492);
        freqMap.put(Character.valueOf('C'), 2.782);
        freqMap.put(Character.valueOf('D'), 4.253);
        freqMap.put(Character.valueOf('E'), 12.702);
        freqMap.put(Character.valueOf('F'), 2.228);
        freqMap.put(Character.valueOf('G'), 2.015);
        freqMap.put(Character.valueOf('H'), 6.094);
        freqMap.put(Character.valueOf('I'), 6.996);
        freqMap.put(Character.valueOf('J'), 0.153);
        freqMap.put(Character.valueOf('K'), 0.772);
        freqMap.put(Character.valueOf('L'), 4.025);
        freqMap.put(Character.valueOf('M'), 2.406);
        freqMap.put(Character.valueOf('N'), 6.749);
        freqMap.put(Character.valueOf('O'), 7.507);
        freqMap.put(Character.valueOf('P'), 1.929);
        freqMap.put(Character.valueOf('Q'), 0.095);
        freqMap.put(Character.valueOf('R'), 5.987);
        freqMap.put(Character.valueOf('S'), 6.327);
        freqMap.put(Character.valueOf('T'), 9.056);
        freqMap.put(Character.valueOf('U'), 2.758);
        freqMap.put(Character.valueOf('V'), 0.978);
        freqMap.put(Character.valueOf('W'), 2.36);
        freqMap.put(Character.valueOf('X'), 0.15);
        freqMap.put(Character.valueOf('Y'), 1.974);
        freqMap.put(Character.valueOf('Z'), 0.074);
        return freqMap;
    }

    @Override
    public void loadNGramData() {
        this.quadgramData = TextFitness.loadFile("/files/english_quadgrams.txt");
        this.trigramData = TextFitness.loadFile("/files/english_trigrams.txt");
        this.bigramData = TextFitness.loadFile("/files/english_bigrams_1.txt");
    }

    @Override
    public NGramData getQuadgramData() {
        return this.quadgramData;
    }

    @Override
    public NGramData getTrigramData() {
        return this.trigramData;
    }

    @Override
    public NGramData getDiagramData() {
        return this.bigramData;
    }

    @Override
    public String getName() {
        return "English";
    }

    @Override
    public String getImagePath() {
        return "/image/english_flag.png";
    }
}

