/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.math;

import com.alexbarter.ciphertool.lib.Cache;
import com.alexbarter.ciphertool.lib.math.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Statistics<T extends Number> {
    private List<T> data = null;
    private Cache<T> max = Cache.create(() -> (Number)((Object)MathUtil.getBiggest(this.data)));
    private Cache<T> min = Cache.create(() -> (Number)((Object)MathUtil.getSmallest(this.data)));
    private Cache<T> sum = Cache.create(() -> MathUtil.sum(this.data));
    private Cache<Double> mean = Cache.create(() -> ((Number)this.sum.get()).doubleValue() / (double)this.data.size());
    private Cache<Double> variance = Cache.create(() -> {
        double mean = this.mean.get();
        double variance = 0.0;
        for (Number n : this.data) {
            variance += Math.pow(mean - n.doubleValue(), 2.0);
        }
        return variance / (double)this.data.size();
    });
    private Cache<Double> standardDeviation = Cache.create(() -> Math.sqrt(this.variance.get()));

    public Statistics(Iterable<T> data) {
        this.data = new ArrayList<T>();
        for (Number n : data) {
            this.data.add(n);
        }
        this.data = Collections.unmodifiableList(this.data);
    }

    public double getMean() {
        return this.mean.get();
    }

    public double getVariance() {
        return this.variance.get();
    }

    public double getStandardDeviation() {
        return this.standardDeviation.get();
    }

    public T getMax() {
        return (T)((Number)this.max.get());
    }

    public T getMin() {
        return (T)((Number)this.min.get());
    }

    public String toString() {
        return String.format("Mean: %f, SD: %f ", this.getMean(), this.getStandardDeviation());
    }
}

