/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.solve;

import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.solve.DecryptionMethod;
import tools.cipher.base.solve.DecryptionTracker;
import tools.cipher.base.solve.IDictionaryAttack;
import tools.cipher.ciphers.AutokeyCipher;
import tools.cipher.solve.PeriodicKeyAttack;

public class AutokeyAttack
extends PeriodicKeyAttack<AutokeyCipher>
implements IDictionaryAttack<String> {
    public AutokeyAttack(AutokeyCipher cipher, String displayName) {
        super(cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY, DecryptionMethod.DICTIONARY, DecryptionMethod.BRUTE_FORCE});
    }

    @Override
    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case DICTIONARY: {
                DecryptionTracker tracker = new DecryptionTracker(text, app);
                return this.tryDictionaryAttack((IDecryptionTracker)tracker);
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public String useWordToGetKey(DecryptionTracker tracker, String word) {
        return this.useStringGetKey((IDecryptionTracker)tracker, word);
    }
}

