/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.QuadKey;
import tools.cipher.base.ciphers.QuadKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.FullStringKeyType;
import tools.cipher.base.key.types.ObjectKeyType;
import tools.cipher.base.key.types.VariableStringKeyType;
import tools.cipher.lib.characters.CharSequenceUtils;
import tools.cipher.util.Quagmire;

public class QuagmireIVCipher
extends QuadKeyCipher<String, String, String, Character, FullStringKeyType.Builder, FullStringKeyType.Builder, VariableStringKeyType.Builder, ObjectKeyType.Builder<Character>> {
    public QuagmireIVCipher() {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"), (IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"), (IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)ObjectKeyType.builder().setUniverse((Object[])CharSequenceUtils.toArray((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ")));
    }

    public VariableStringKeyType.Builder limitDomainForThirdKey(VariableStringKeyType.Builder thirdKey) {
        return thirdKey.setRange(2, 15);
    }

    public CharSequence encode(CharSequence plainText, QuadKey<String, String, String, Character> key) {
        return Quagmire.encode(plainText, (String)key.getFirstKey(), (String)key.getSecondKey(), (String)key.getThirdKey(), ((Character)key.getFourthKey()).charValue());
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, QuadKey<String, String, String, Character> key) {
        return Quagmire.decode(cipherText, plainText, (String)key.getFirstKey(), (String)key.getSecondKey(), (String)key.getThirdKey(), ((Character)key.getFourthKey()).charValue());
    }
}

