/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import java.util.Arrays;
import java.util.List;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.OrderedIntegerKeyType;
import tools.cipher.lib.MorseCode;

public class MorbitCipher
extends UniKeyCipher<Integer[], OrderedIntegerKeyType.Builder> {
    public MorbitCipher() {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setRange(9, 9));
    }

    public CharSequence encode(CharSequence plainText, Integer[] key) {
        String cipherText = "";
        String morseText = "";
        morseText = MorseCode.getMorseEquivalent((CharSequence)plainText);
        if (morseText.length() % 2 != 0) {
            morseText = morseText + "X";
        }
        List<Character> list = Arrays.asList(Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('X'));
        for (int i = 0; i < morseText.length(); i += 2) {
            int a = list.indexOf(Character.valueOf(morseText.charAt(i)));
            int b = list.indexOf(Character.valueOf(morseText.charAt(i + 1)));
            cipherText = cipherText + (key[a * 3 + b] + 1);
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, Integer[] key) {
        int[] reversedOrder = new int[key.length];
        for (int i = 0; i < key.length; ++i) {
            reversedOrder[key[i].intValue()] = i;
        }
        StringBuilder plainText = new StringBuilder();
        char[] morseText = new char[cipherText.length() * 2];
        char[] list = new char[]{'.', '-', 'X'};
        for (int i = 0; i < cipherText.length(); ++i) {
            int a = cipherText.charAt(i) - 48 - 1;
            int index = reversedOrder[a];
            int first = index / 3;
            int second = index % 3;
            morseText[i * 2] = list[first];
            morseText[i * 2 + 1] = list[second];
        }
        int last = 0;
        for (int i = 0; i < morseText.length; ++i) {
            boolean end;
            char a = morseText[i];
            boolean isX = a == 'X';
            boolean bl = end = i == morseText.length - 1;
            if (!isX && !end) continue;
            String code = new String(morseText, last, i - last + (end && !isX ? 1 : 0));
            last = i + 1;
            Character morseChar = MorseCode.getCharFromMorse((String)code);
            if (morseChar != null) {
                plainText.append(morseChar.charValue());
                continue;
            }
            plainText.append(morseText, last, i - last + (end && !isX ? 1 : 0));
        }
        return plainText.toString().toCharArray();
    }

    public char[] decodeEfficiently(CharSequence cipherText, char[] unused, Integer[] key) {
        int[] reversedOrder = new int[key.length];
        for (int i = 0; i < key.length; ++i) {
            reversedOrder[key[i].intValue()] = i;
        }
        StringBuilder plainText = new StringBuilder();
        char[] morseText = new char[cipherText.length() * 2];
        char[] list = new char[]{'.', '-', 'X'};
        for (int i = 0; i < cipherText.length(); ++i) {
            int a = cipherText.charAt(i) - 48 - 1;
            int index = reversedOrder[a];
            int first = index / 3;
            int second = index % 3;
            morseText[i * 2] = list[first];
            morseText[i * 2 + 1] = list[second];
        }
        int last = 0;
        for (int i = 0; i < morseText.length; ++i) {
            boolean end;
            char a = morseText[i];
            boolean isX = a == 'X';
            boolean bl = end = i == morseText.length - 1;
            if (!isX && !end) continue;
            String code = new String(morseText, last, i - last + (end && !isX ? 1 : 0));
            last = i + 1;
            Character morseChar = MorseCode.getCharFromMorse((String)code);
            if (morseChar != null) {
                plainText.append(morseChar.charValue());
                continue;
            }
            plainText.append(morseText, last, i - last + (end && !isX ? 1 : 0));
        }
        return plainText.toString().toCharArray();
    }
}

