/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.solve;

import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.key.IRangedKeyType;
import tools.cipher.base.solve.CipherAttack;
import tools.cipher.base.solve.DecryptionMethod;
import tools.cipher.base.solve.IKeySearchAttack;

public class HomophonicAttack<C extends UniKeyCipher<String, ? extends IRangedKeyType.IRangedKeyBuilder<String>>>
extends CipherAttack<String, C>
implements IKeySearchAttack<String> {
    public int[] periodRange;
    private int charStep = 1;

    public HomophonicAttack(C cipher, String displayName) {
        super(cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY, DecryptionMethod.BRUTE_FORCE});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case PERIODIC_KEY: {
                return this.tryKeySearch(this.createTracker(text, app), 4);
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public String useStringGetKey(IDecryptionTracker tracker, String periodicPart) {
        return periodicPart;
    }

    public int getCharStep() {
        return this.charStep;
    }

    public HomophonicAttack<C> setCharStep(int charStep) {
        this.charStep = charStep;
        return this;
    }

    public IDecryptionTracker createTracker(CharSequence text, ICipherProgram app) {
        return super.createTracker(text, app).setOutputLength(length -> length / 2);
    }
}

