/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.SwagmanKeyType;
import tools.cipher.lib.characters.CharacterArrayWrapper;

public class SwagmanCipher
extends UniKeyCipher<int[], SwagmanKeyType.Builder> {
    public SwagmanCipher() {
        super((IKeyType.IKeyBuilder)SwagmanKeyType.builder().setRange(2, Integer.MAX_VALUE));
    }

    public SwagmanKeyType.Builder limitDomainForFirstKey(SwagmanKeyType.Builder secondKey) {
        return secondKey.setRange(2, 5);
    }

    public CharSequence normaliseText(CharSequence plainText, int[] key) {
        int size = (int)Math.sqrt(key.length);
        StringBuilder builder = new StringBuilder(plainText.length() + (size - plainText.length() % size) % size);
        builder.append(plainText);
        while (builder.length() % size != 0) {
            builder.append('X');
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, int[] key) {
        int c;
        int r;
        int s;
        int size = (int)Math.sqrt(key.length);
        char[] tempText = new char[plainText.length()];
        Character[] cipherText = new Character[plainText.length()];
        int squareMag = key.length;
        int rowLength = plainText.length() / size;
        int noSquares = (int)Math.ceil((double)plainText.length() / (double)squareMag);
        int[] colInSquare = new int[noSquares];
        for (int i = 0; i < noSquares; ++i) {
            colInSquare[i] = size;
        }
        if (plainText.length() % squareMag != 0) {
            colInSquare[noSquares - 1] = plainText.length() % squareMag / size;
        }
        for (s = 0; s < noSquares; ++s) {
            for (r = 0; r < size; ++r) {
                for (c = 0; c < colInSquare[s]; ++c) {
                    tempText[s * squareMag + c + colInSquare[s] * key[r * size + c % size]] = plainText.charAt(s * size + r * rowLength + c);
                }
            }
        }
        for (s = 0; s < noSquares; ++s) {
            for (r = 0; r < size; ++r) {
                for (c = 0; c < colInSquare[s]; ++c) {
                    cipherText[s * squareMag + c * size + r] = Character.valueOf(tempText[s * squareMag + c + colInSquare[s] * r]);
                }
            }
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, int[] key) {
        int r;
        int i;
        int size = (int)Math.sqrt(key.length);
        int[] inKey = new int[key.length];
        for (int c = 0; c < size; ++c) {
            for (int r2 = 0; r2 < size; ++r2) {
                inKey[key[r2 * size + c] * size + c] = r2;
            }
        }
        char[] tempText = new char[cipherText.length()];
        int squareMag = (int)Math.pow(size, 2.0);
        int noSquares = (int)Math.ceil((double)cipherText.length() / (double)squareMag);
        int[] colInSquare = new int[noSquares];
        for (i = 0; i < noSquares; ++i) {
            colInSquare[i] = size;
        }
        if (cipherText.length() % squareMag != 0) {
            colInSquare[noSquares - 1] = cipherText.length() % squareMag / size;
        }
        for (int s = 0; s < noSquares; ++s) {
            for (r = 0; r < size; ++r) {
                for (int c = 0; c < colInSquare[s]; ++c) {
                    tempText[s * squareMag + c + colInSquare[s] * inKey[r * size + c % size]] = cipherText.charAt(s * squareMag + c * size + r);
                }
            }
        }
        i = 0;
        for (r = 0; r < size; ++r) {
            for (int s = 0; s < noSquares; ++s) {
                for (int c = 0; c < colInSquare[s]; ++c) {
                    plainText[i++] = tempText[s * squareMag + c + r * colInSquare[s]];
                }
            }
        }
        return plainText;
    }
}

