/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import com.alexbarter.lib.util.MathUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.VariableStringKeyType;

public class HomophonicCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    public HomophonicCipher() {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setRange(4, 4));
    }

    public CharSequence normaliseText(CharSequence plainText, String key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, String key) {
        int charIndex;
        int i;
        StringBuilder cipherText = new StringBuilder();
        ArrayList<char[]> rows = new ArrayList<char[]>();
        for (i = 0; i < 4; ++i) {
            charIndex = key.charAt(i) - 65;
            if (key.charAt(i) >= 'J') {
                --charIndex;
            }
            for (int no = 0; no < 25; ++no) {
                int num = (i * 25 + (no + 25 - charIndex) % 25 + 1) % 100;
                int digit = num % 10;
                int tens = (num - digit) / 10;
                rows.add(new char[]{(char)(tens + 48), (char)(digit + 48)});
            }
        }
        for (i = 0; i < plainText.length(); ++i) {
            charIndex = plainText.charAt(i) - 65;
            if (charIndex >= 9) {
                --charIndex;
            }
            cipherText.append((char[])rows.get(RandomUtil.pickRandomInt((int)4) * 25 + charIndex));
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, String key) {
        return this.decodeEfficiently(cipherText, new char[cipherText.length() / 2], key);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int i;
        int[] rows = new int[100];
        String shortAlpha = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
        for (i = 0; i < 4; ++i) {
            int c = key.charAt(i) - 65;
            if (key.charAt(i) >= 'J') {
                --c;
            }
            for (int no = 0; no < 25; ++no) {
                rows[(i * 25 + MathUtil.mod((int)(no - c), (int)25) + 1) % 100] = no;
            }
        }
        for (i = 0; i < plainText.length; ++i) {
            int col = rows[10 * (cipherText.charAt(i * 2) - 48) + (cipherText.charAt(i * 2 + 1) - 48)];
            plainText[i] = shortAlpha.charAt(col);
        }
        return plainText;
    }

    public boolean deterministic() {
        return false;
    }
}

