/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.solve;

import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.settings.ICipherSettingProvider;
import tools.cipher.base.settings.SettingTypes;
import tools.cipher.base.solve.CipherAttack;
import tools.cipher.base.solve.DecryptionMethod;
import tools.cipher.base.solve.DecryptionTracker;
import tools.cipher.base.solve.IDictionaryAttack;
import tools.cipher.base.solve.IKeySearchAttack;
import tools.cipher.ciphers.NicodemusCipher;

public class NicodemusAttack
extends CipherAttack<BiKey<String, Integer>, NicodemusCipher>
implements IKeySearchAttack<BiKey<String, Integer>>,
IDictionaryAttack<BiKey<String, Integer>> {
    public int[] periodRange;

    public NicodemusAttack(NicodemusCipher cipher, String displayName) {
        super((ICipher)cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.DICTIONARY, DecryptionMethod.BRUTE_FORCE, DecryptionMethod.PERIODIC_KEY});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)4, (int)2, (int)100, (int)1, (values, cipher2) -> {
            this.periodRange = values;
            cipher2.setFirstKeyDomain(builder -> builder.setRange(values));
        })});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntSpinner((String)"block_size", (int)5, (int)1, (int)100, (int)1, (values, cipher2) -> cipher2.setSecondKeyDomain(builder -> builder.setSize(values.intValue())))});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        IDecryptionTracker tracker = this.createTracker(text, app);
        switch (method) {
            case PERIODIC_KEY: {
                for (int period = this.periodRange[0]; period <= this.periodRange[1]; ++period) {
                    this.tryKeySearch(tracker, period);
                }
                return tracker;
            }
            case DICTIONARY: {
                return this.tryDictionaryAttack(tracker);
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public BiKey<String, Integer> useStringGetKey(IDecryptionTracker tracker, String periodicPart) {
        return ((BiKey)((NicodemusCipher)this.getCipher()).randomiseKey(tracker.getLength())).setFirst((Object)periodicPart);
    }

    public BiKey<String, Integer> useWordToGetKey(DecryptionTracker tracker, String word) {
        return this.useStringGetKey((IDecryptionTracker)tracker, word);
    }
}

