/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.VariableStringKeyType;
import tools.cipher.lib.characters.CharacterArrayWrapper;
import tools.cipher.util.VigenereType;

public class AutokeyCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    private VigenereType type;

    public AutokeyCipher(VigenereType type) {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(1, Integer.MAX_VALUE));
        this.type = type;
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(2, 15);
    }

    public CharSequence encode(CharSequence plainText, String key) {
        Character[] cipherText = new Character[plainText.length()];
        int period = key.length();
        for (int index = 0; index < plainText.length(); ++index) {
            char charIdKey = index < period ? key.charAt(index) : plainText.charAt(index - period);
            cipherText[index] = Character.valueOf(this.type.encode(plainText.charAt(index), charIdKey));
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int period = key.length();
        for (int index = 0; index < cipherText.length(); ++index) {
            char charIdKey = index < period ? key.charAt(index) : plainText[index - period];
            plainText[index] = this.type.decode(cipherText.charAt(index), charIdKey);
        }
        return plainText;
    }
}

