/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.QuadKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.base.solve.ISimulatedAnnealingAttack;
import com.alexbarter.ciphertool.ciphers.RouteTranspositionCipher;
import com.alexbarter.ciphertool.ciphers.route.RouteCipherType;
import com.alexbarter.ciphertool.ciphers.route.Routes;
import com.alexbarter.ciphertool.lib.CipherUtils;
import com.alexbarter.lib.util.MathUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RouteAttack
extends CipherAttack<QuadKey<Integer, Integer, RouteCipherType, RouteCipherType>, RouteTranspositionCipher>
implements ISimulatedAnnealingAttack<QuadKey<Integer, Integer, RouteCipherType, RouteCipherType>> {
    public RouteAttack() {
        super((ICipher)new RouteTranspositionCipher(), "Route Transposition");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case BRUTE_FORCE: {
                return this.trySimulatedAnnealing((IDecryptionTracker)new DecryptionTracker(text, app), 1000);
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public IDecryptionTracker tryBruteForce(IDecryptionTracker tracker) {
        BigInteger totalKeys = ((RouteTranspositionCipher)this.getCipher()).getNumOfKeys();
        this.output(tracker, CipherUtils.formatBigInteger((BigInteger)totalKeys) + " Keys to search", new Object[0]);
        tracker.getProgress().addMax(totalKeys);
        List factors = MathUtil.getFactors((int)tracker.getLength());
        factors.removeAll(Arrays.asList(1, tracker.getLength()));
        this.output(tracker, "Factors - " + factors, new Object[0]);
        tracker.getProgress().addMax((long)((factors.size() - 2) * (int)Math.pow(Routes.getRoutes().size(), 2.0)));
        Iterator iterator = factors.iterator();
        block0: while (iterator.hasNext()) {
            int factor = (Integer)iterator.next();
            int totalSize = tracker.getLength();
            int width = factor;
            int height = totalSize / width;
            for (RouteCipherType type2 : Routes.getRoutes()) {
                for (RouteCipherType type : Routes.getRoutes()) {
                    if (tracker.shouldStop()) break block0;
                    this.decryptAndUpdate(tracker, QuadKey.of((Object)width, (Object)height, (Object)type2, (Object)type));
                    tracker.getProgress().increment();
                }
            }
        }
        tracker.getProgress().finish();
        return tracker;
    }
}

