/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.base.solve.IDictionaryAttack;
import com.alexbarter.ciphertool.ciphers.CadenusCipher;
import com.alexbarter.ciphertool.lib.result.Solution;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class CadenusAttack
extends CipherAttack<String, CadenusCipher>
implements IDictionaryAttack<String> {
    public CadenusAttack() {
        super((ICipher)new CadenusCipher(), "Cadenus");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.DICTIONARY, DecryptionMethod.BRUTE_FORCE});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)8, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setDomain(builder -> builder.setRange(values)))});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case DICTIONARY: {
                return this.tryDictionaryAttack((IDecryptionTracker)new DecryptionTracker(text, app));
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public Supplier<Predicate<String>> getWordFilter(DecryptionTracker tracker) {
        List factors = MathUtil.getFactors((int)(tracker.getCipherText().length() / 25));
        return () -> key -> factors.contains(key.length());
    }

    public String useWordToGetKey(DecryptionTracker tracker, String word) {
        return word;
    }

    public Solution toSolution(IDecryptionTracker tracker, String key) {
        int blockSize = key.length() * 25;
        char[] plainText = new char[]{};
        for (int i = 0; i < tracker.getCipherText().length() / blockSize; ++i) {
            plainText = ArrayUtil.concat((char[])plainText, (char[])((CadenusCipher)this.getCipher()).decodeEfficiently(tracker.getCipherText().subSequence(i * blockSize, (i + 1) * blockSize), key));
        }
        return new Solution(plainText, tracker.getLanguage());
    }
}

