/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import com.alexbarter.ciphertool.util.VigenereType;
import javax.annotation.Nullable;

public class NicodemusCipher
extends BiKeyCipher<String, Integer, VariableStringKeyType.Builder, IntegerKeyType.Builder> {
    private VigenereType type;

    public NicodemusCipher(VigenereType type) {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(3, 10), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(1, Integer.MAX_VALUE));
        this.type = type;
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(3, 10);
    }

    public IntegerKeyType.Builder limitDomainForSecondKey(IntegerKeyType.Builder secondKey) {
        return secondKey.setRange(1, 10);
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, Integer> key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        int[] order = new int[((String)key.getFirstKey()).length()];
        int p = 0;
        for (int ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            int keyindex = ((String)key.getFirstKey()).indexOf(ch);
            if (keyindex == -1) continue;
            order[p++] = keyindex;
        }
        int start_row = 0;
        int total_row = (int)Math.ceil((double)plainText.length() / (double)((String)key.getFirstKey()).length());
        while (start_row < total_row) {
            int end_row = Math.min(total_row, start_row + (Integer)key.getSecondKey());
            for (int col = 0; col < ((String)key.getFirstKey()).length(); ++col) {
                for (int row = start_row; row < end_row; ++row) {
                    if (row * ((String)key.getFirstKey()).length() + order[col] >= plainText.length()) continue;
                    cipherText.append(this.type.encode(plainText.charAt(row * ((String)key.getFirstKey()).length() + order[col]), ((String)key.getFirstKey()).charAt(order[col] % ((String)key.getFirstKey()).length())));
                }
            }
            start_row = end_row;
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, Integer> key) {
        int blockSize;
        String keyword = (String)key.getFirstKey();
        int READ_OFF = (Integer)key.getSecondKey();
        byte[] order = new byte[keyword.length()];
        int q = 0;
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + 1)) {
            for (int i = 0; i < order.length; i = (int)((byte)(i + 1))) {
                if (ch != keyword.charAt(i)) continue;
                order[q++] = i;
            }
        }
        int blocks = (int)Math.ceil((double)cipherText.length() / (double)(keyword.length() * READ_OFF));
        boolean complete = blocks * (blockSize = keyword.length() * READ_OFF) == cipherText.length();
        int index = 0;
        for (int b = 0; b < blocks; ++b) {
            for (int r = 0; r < READ_OFF; ++r) {
                for (int p = 0; p < keyword.length(); ++p) {
                    if (complete || blocks - 1 != b) {
                        int row = index % keyword.length();
                        plainText[order[p] - row + index++] = this.type.decode(cipherText.charAt(b * blockSize + p * READ_OFF + r), keyword.charAt(order[p] % keyword.length()));
                        continue;
                    }
                    int charactersLeft = cipherText.length() - b * blockSize;
                    int lastRow = charactersLeft % keyword.length();
                    int estimate = (int)Math.floor(charactersLeft / keyword.length());
                    index = 0;
                    for (int i = 0; i < keyword.length(); ++i) {
                        int total = estimate;
                        if (lastRow > order[i]) {
                            ++total;
                        }
                        for (int j = 0; j < total; ++j) {
                            byte place = order[i];
                            plainText[b * blockSize + j * keyword.length() + place] = this.type.decode(cipherText.charAt(b * blockSize + index + j), keyword.charAt(place % keyword.length()));
                        }
                        index += total;
                    }
                }
            }
        }
        return plainText;
    }
}

