/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.key.types.OrderedIntegerKeyType;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;

public class RedefenceCipher
implements ICipher<BiKey<Integer[], Integer>> {
    protected final OrderedIntegerKeyType firstType;
    private OrderedIntegerKeyType firstTypeLimit;
    private final OrderedIntegerKeyType.Builder firstKeyBuilder;

    public RedefenceCipher() {
        OrderedIntegerKeyType.Builder firstKey = OrderedIntegerKeyType.builder().setRange(2, 0x3FFFFFFD);
        this.firstType = firstKey.create();
        this.firstTypeLimit = firstKey.setRange(2, 9).create();
        this.firstKeyBuilder = firstKey;
    }

    public boolean isValid(BiKey<Integer[], Integer> key) {
        return this.firstType.isValid((Integer[])key.getFirstKey()) && 0 <= (Integer)key.getSecondKey() && (Integer)key.getSecondKey() < (((Integer[])key.getFirstKey()).length - 1) * 2;
    }

    public BiKey<Integer[], Integer> randomiseKey() {
        Integer[] rails = this.firstTypeLimit.randomise();
        return BiKey.of((Object)rails, (Object)RandomUtil.pickRandomInt((int)0, (int)((rails.length - 1) * 2 - 1)));
    }

    public boolean iterateKeys(Function<BiKey<Integer[], Integer>, Boolean> consumer) {
        return this.firstTypeLimit.iterateKeys(f -> {
            Integer[] fCopy = (Integer[])ArrayUtil.copy((Object[])f);
            for (int s = 0; s < (((Integer[])f).length - 1) * 2; ++s) {
                if (((Boolean)consumer.apply(BiKey.of((Object)fCopy, (Object)s))).booleanValue()) continue;
                return false;
            }
            return true;
        });
    }

    public BiKey<Integer[], Integer> alterKey(BiKey<Integer[], Integer> key, double temp, int count) {
        return key;
    }

    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ZERO;
        for (int i = this.firstTypeLimit.getMin(); i <= this.firstTypeLimit.getMax(); ++i) {
            total = total.add(MathUtil.factorialBig((int)i).multiply(BigInteger.valueOf((i - 1) * 2)));
        }
        return total;
    }

    public String prettifyKey(BiKey<Integer[], Integer> key) {
        return String.join((CharSequence)" ", this.firstType.prettifyKey((Integer[])key.getFirstKey()), String.valueOf(key.getSecondKey()));
    }

    public void limitDomainForFirstKey(Function<OrderedIntegerKeyType.Builder, OrderedIntegerKeyType.Builder> firstKeyFunc) {
        this.firstTypeLimit = firstKeyFunc.apply(this.firstKeyBuilder).create();
    }

    public OrderedIntegerKeyType getFirstKeyType() {
        return this.firstTypeLimit;
    }

    public CharSequence encode(CharSequence plainText, BiKey<Integer[], Integer> key) {
        return RedefenceCipher.encodeGeneral(plainText, ((Integer[])key.getFirstKey()).length, (Integer)key.getSecondKey(), i -> ((Integer[])key.getFirstKey())[i]);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Integer[], Integer> key) {
        return RedefenceCipher.decodeGeneral(cipherText, plainText, ((Integer[])key.getFirstKey()).length, (Integer)key.getSecondKey(), i -> ((Integer[])key.getFirstKey())[i]);
    }

    protected static CharSequence encodeGeneral(CharSequence plainText, int rows, int startingOffset, IntFunction<Integer> takeOffOrder) {
        StringBuilder[] rails = (StringBuilder[])ArrayUtil.fill((Object[])new StringBuilder[rows], StringBuilder::new);
        int branchTotal = rows * 2 - 2;
        for (int i = 0; i < plainText.length(); ++i) {
            char character = plainText.charAt(i);
            int index_in_ite = (i + startingOffset) % branchTotal;
            if (index_in_ite < rows) {
                rails[index_in_ite].append(character);
                continue;
            }
            rails[rows - (index_in_ite - rows) - 2].append(character);
        }
        StringBuilder cipherText = new StringBuilder();
        for (int i = 0; i < rows; ++i) {
            cipherText.append((CharSequence)rails[takeOffOrder.apply(i)]);
        }
        return cipherText;
    }

    protected static char[] decodeGeneral(CharSequence cipherText, @Nullable char[] plainText, int rows, int startingOffset, IntFunction<Integer> takeOffOrder) {
        int ghostLength = cipherText.length() + startingOffset;
        int branchTotal = 2 * (rows - 1);
        int branchs = ghostLength / branchTotal;
        int noUnassigned = ghostLength - branchs * branchTotal;
        int index = 0;
        for (int k = 0; k < rows && index < cipherText.length(); ++k) {
            int row = takeOffOrder.apply(k) + 1;
            int occurs = branchs;
            if (row > 1 && row < rows) {
                occurs *= 2;
            }
            if (noUnassigned >= row) {
                ++occurs;
                if (row < rows && row + (rows - row) * 2 <= noUnassigned) {
                    ++occurs;
                }
            }
            if (startingOffset >= row) {
                --occurs;
                if (row < rows && row + (rows - row) * 2 <= startingOffset) {
                    --occurs;
                }
            }
            for (int i = 0; i < occurs; ++i) {
                int newIndex = 0;
                if (row > 1 && row < rows) {
                    int branch2 = i;
                    if (startingOffset >= row) {
                        ++branch2;
                        if (row < rows && row + (rows - row) * 2 <= startingOffset) {
                            ++branch2;
                        }
                    }
                    int branch = branch2 / 2;
                    newIndex = branch * branchTotal + row - 1 - startingOffset;
                    if (branch2 % 2 == 1) {
                        newIndex += (rows - row) * 2;
                    }
                    plainText[newIndex] = cipherText.charAt(index++);
                    continue;
                }
                int branch = i;
                if (startingOffset >= row) {
                    ++branch;
                }
                newIndex = branch * branchTotal + row - 1 - startingOffset;
                plainText[newIndex] = cipherText.charAt(index++);
            }
        }
        return plainText;
    }
}

