/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers.registry;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ILoadHook;
import com.alexbarter.ciphertool.base.interfaces.ISettings;
import com.alexbarter.ciphertool.base.key.types.IntegerKeyType;
import com.alexbarter.ciphertool.base.key.types.OrderedIntegerKeyType;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.ciphers.AMSCOCipher;
import com.alexbarter.ciphertool.ciphers.AffineCipher;
import com.alexbarter.ciphertool.ciphers.AutokeyCipher;
import com.alexbarter.ciphertool.ciphers.BazeriesCipher;
import com.alexbarter.ciphertool.ciphers.BifidCipher;
import com.alexbarter.ciphertool.ciphers.CaesarCipher;
import com.alexbarter.ciphertool.ciphers.ColumnarTranspositionCipher;
import com.alexbarter.ciphertool.ciphers.ConjugatedBifidCipher;
import com.alexbarter.ciphertool.ciphers.DigrafidCipher;
import com.alexbarter.ciphertool.ciphers.FourSquareCipher;
import com.alexbarter.ciphertool.ciphers.FractionatedMorseCipher;
import com.alexbarter.ciphertool.ciphers.GrilleCipher;
import com.alexbarter.ciphertool.ciphers.HomophonicCipher;
import com.alexbarter.ciphertool.ciphers.HuttonCipher;
import com.alexbarter.ciphertool.ciphers.KeywordCipher;
import com.alexbarter.ciphertool.ciphers.MyszkowskiCipher;
import com.alexbarter.ciphertool.ciphers.NicodemusCipher;
import com.alexbarter.ciphertool.ciphers.NihilistTranspositionCipher;
import com.alexbarter.ciphertool.ciphers.PeriodicGromarkCipher;
import com.alexbarter.ciphertool.ciphers.PhillipsCipher;
import com.alexbarter.ciphertool.ciphers.PlayfairCipher;
import com.alexbarter.ciphertool.ciphers.PolluxCipher;
import com.alexbarter.ciphertool.ciphers.PortaxCipher;
import com.alexbarter.ciphertool.ciphers.ProgressiveCipher;
import com.alexbarter.ciphertool.ciphers.QuagmireICipher;
import com.alexbarter.ciphertool.ciphers.QuagmireIICipher;
import com.alexbarter.ciphertool.ciphers.QuagmireIIICipher;
import com.alexbarter.ciphertool.ciphers.QuagmireIVCipher;
import com.alexbarter.ciphertool.ciphers.RagbabyCipher;
import com.alexbarter.ciphertool.ciphers.RailFenceCipher;
import com.alexbarter.ciphertool.ciphers.RedefenceCipher;
import com.alexbarter.ciphertool.ciphers.SeriatedPlayfairCipher;
import com.alexbarter.ciphertool.ciphers.SlidefairCipher;
import com.alexbarter.ciphertool.ciphers.TriSquareCipher;
import com.alexbarter.ciphertool.ciphers.TrifidCipher;
import com.alexbarter.ciphertool.ciphers.TwoSquareCipher;
import com.alexbarter.ciphertool.ciphers.VigenereCipher;
import com.alexbarter.ciphertool.lib.characters.CharSequenceUtils;
import com.alexbarter.ciphertool.lib.registry.IRegistry;
import com.alexbarter.ciphertool.lib.registry.Registry;
import com.alexbarter.ciphertool.solve.ADFGXAttack;
import com.alexbarter.ciphertool.solve.AutokeyAttack;
import com.alexbarter.ciphertool.solve.CadenusAttack;
import com.alexbarter.ciphertool.solve.EnigmaAttack;
import com.alexbarter.ciphertool.solve.EnigmaPlugboardAttack;
import com.alexbarter.ciphertool.solve.EnigmaUhrAttack;
import com.alexbarter.ciphertool.solve.GeneralPeriodAttack;
import com.alexbarter.ciphertool.solve.HillAttack;
import com.alexbarter.ciphertool.solve.HillExtendedAttack;
import com.alexbarter.ciphertool.solve.HillSubsitutionAttack;
import com.alexbarter.ciphertool.solve.HomophonicAttack;
import com.alexbarter.ciphertool.solve.NicodemusAttack;
import com.alexbarter.ciphertool.solve.NihilistSubstitutionAttack;
import com.alexbarter.ciphertool.solve.PeriodicKeyAttack;
import com.alexbarter.ciphertool.solve.PolybusSquareAttack;
import com.alexbarter.ciphertool.solve.ProgressiveKeyAttack;
import com.alexbarter.ciphertool.solve.RouteAttack;
import com.alexbarter.ciphertool.solve.SlidefairAttack;
import com.alexbarter.ciphertool.solve.SolitaireAttack;
import com.alexbarter.ciphertool.solve.StraddleCheckerboardAttack;
import com.alexbarter.ciphertool.util.AMSCOType;
import com.alexbarter.ciphertool.util.ReadMode;
import com.alexbarter.ciphertool.util.VigenereType;
import com.alexbarter.lib.util.ArrayUtil;

public class AttackRegistry {
    public static final IRegistry<String, CipherAttack> CIPHERS = Registry.builder(CipherAttack.class).setNamingScheme((reg, value) -> "CIPHER_" + reg.size()).build();

    public static void registerCipher(CipherAttack cipherAttack, ISettings settings) {
        AttackRegistry.registerCipher("CIPHER_" + CIPHERS.size(), cipherAttack, settings);
    }

    public static void registerCipher(String id, CipherAttack cipherAttack, ISettings settings) {
        CIPHERS.register((Object)id, (Object)cipherAttack);
        settings.addHook((ILoadHook)cipherAttack);
    }

    public static void loadCiphers(ISettings settings) {
        AttackRegistry.registerCipher("amsco", new CipherAttack((ICipher)new AMSCOCipher(), "AMSCO").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)10, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setFirstKeyDomain(builder -> builder.setRange(values)))}).addSetting(new ICipherSettingProvider[]{SettingTypes.createCombo((String)"type", (Object[])AMSCOType.values(), (value, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setUniverse((Enum[])new AMSCOType[]{value})))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("affine", new CipherAttack((ICipher)new AffineCipher(), "Affine").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("bazeries", new CipherAttack((ICipher)new BazeriesCipher(), "Bazeries").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("caesar", new CipherAttack((ICipher)new CaesarCipher(), "Caesar").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("pollux", new CipherAttack((ICipher)new PolluxCipher(), "Pollux").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("railfence", new CipherAttack((ICipher)new RailFenceCipher(), "Railfence").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)50, (int)2, (int)1000, (int)1, (values, cipher) -> cipher.limitDomainForFirstKey(builder -> (IntegerKeyType.Builder)builder.setRange(values)))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("redefence", new CipherAttack((ICipher)new RedefenceCipher(), "Redefence").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)7, (int)2, (int)100, (int)1, (values, cipher) -> cipher.limitDomainForFirstKey(builder -> (OrderedIntegerKeyType.Builder)builder.setRange(values)))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("columnar_transposition", new CipherAttack((ICipher)new ColumnarTranspositionCipher(), "Columnar Transposition").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)10, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setFirstKeyDomain(builder -> builder.setRange(values)))}).addSetting(new ICipherSettingProvider[]{SettingTypes.createCombo((String)"read_mode", (Object[])ReadMode.values(), (value, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setUniverse((Enum[])new ReadMode[]{value})))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("grille", new CipherAttack((ICipher)new GrilleCipher(), "Grille").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"size_range", (int)2, (int)10, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setDomain(builder -> builder.setRange(values)))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("hutton", new CipherAttack((ICipher)new HuttonCipher(), "Hutton").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range_key1", (int)2, (int)5, (int)1, (int)100, (int)1, (values, cipher) -> cipher.setFirstKeyDomain(builder -> builder.setRange(values)))}).addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range_key2", (int)2, (int)5, (int)1, (int)100, (int)1, (values, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setRange(values)))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE, DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("phillips", new CipherAttack((ICipher)new PhillipsCipher(), "Phillips").addSetting(new ICipherSettingProvider[]{SettingTypes.createCombo((String)"swap_rows", (Object[])new Boolean[]{true, false}, (value, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setUniverse(new Boolean[]{value})))}).addSetting(new ICipherSettingProvider[]{SettingTypes.createCombo((String)"swap_cols", (Object[])new Boolean[]{true, false}, (value, cipher) -> cipher.setThirdKeyDomain(builder -> builder.setUniverse(new Boolean[]{value})))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("trifid", new CipherAttack((ICipher)new TrifidCipher(), "Trifid").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("playfair", new CipherAttack((ICipher)new PlayfairCipher(), "Playfair").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("general_polybus", new PolybusSquareAttack(), settings);
        AttackRegistry.registerCipher("playfair.6x6", new CipherAttack((ICipher)new PlayfairCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), "Playfair 6x6").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("playfair.seriated", new CipherAttack((ICipher)new SeriatedPlayfairCipher(), "Seriated Playfair").addSetting(new ICipherSettingProvider[]{SettingTypes.createSpinner((String)"period", (Object[])((Integer[])ArrayUtil.concatGeneric((Object[])new Integer[]{0}, (Object[])ArrayUtil.createRangeInteger((int)2, (int)101))), (value, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setSize(value.intValue())))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("keyword", new CipherAttack((ICipher)new KeywordCipher(), "Simple Subsitution").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("fractionated_morse", new CipherAttack((ICipher)new FractionatedMorseCipher(), "Fractionated Morse").setOutputLength(length -> length * 3).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("homophonic", new HomophonicAttack<HomophonicCipher>(new HomophonicCipher(), "Homophonic"), settings);
        AttackRegistry.registerCipher("portax", new PeriodicKeyAttack<PortaxCipher>(new PortaxCipher(), "Portax").setCharStep(2), settings);
        AttackRegistry.registerCipher("peridoic_gromark", new PeriodicKeyAttack<PeriodicGromarkCipher>(new PeriodicGromarkCipher(), "Periodic Gromark"), settings);
        AttackRegistry.registerCipher("vigenere", new PeriodicKeyAttack<VigenereCipher>(new VigenereCipher(VigenereType.VIGENERE), "Vigenere"), settings);
        AttackRegistry.registerCipher("porta", new PeriodicKeyAttack<VigenereCipher>(new VigenereCipher(VigenereType.PORTA), "Porta").setCharStep(2), settings);
        AttackRegistry.registerCipher("variant", new PeriodicKeyAttack<VigenereCipher>(new VigenereCipher(VigenereType.VARIANT), "Variant"), settings);
        AttackRegistry.registerCipher("beaufort", new PeriodicKeyAttack<VigenereCipher>(new VigenereCipher(VigenereType.BEAUFORT), "Beaufort"), settings);
        AttackRegistry.registerCipher("vigenere.progressive_key", new ProgressiveKeyAttack(new ProgressiveCipher(VigenereType.VIGENERE), "Vigenere Progressive Key"), settings);
        AttackRegistry.registerCipher("porta.progressive_key", new ProgressiveKeyAttack(new ProgressiveCipher(VigenereType.PORTA), "Porta Progressive Key"), settings);
        AttackRegistry.registerCipher("porta.variant.progressive_key", new ProgressiveKeyAttack(new ProgressiveCipher(VigenereType.PORTA_VARIANT), "Porta Variant Progressive Key"), settings);
        AttackRegistry.registerCipher("variant.progressive_key", new ProgressiveKeyAttack(new ProgressiveCipher(VigenereType.VARIANT), "Variant Progressive Key"), settings);
        AttackRegistry.registerCipher("beaufort.progressive_key", new ProgressiveKeyAttack(new ProgressiveCipher(VigenereType.BEAUFORT), "Beaufort Progressive Key"), settings);
        AttackRegistry.registerCipher("vigenere.autokey", new AutokeyAttack(new AutokeyCipher(VigenereType.VIGENERE), "Vigenere Autokey"), settings);
        AttackRegistry.registerCipher("porta.autokey", new AutokeyAttack(new AutokeyCipher(VigenereType.PORTA), "Porta Autokey").setCharStep(2), settings);
        AttackRegistry.registerCipher("porta.variant.autokey", new AutokeyAttack(new AutokeyCipher(VigenereType.PORTA_VARIANT), "Porta Variant Autokey"), settings);
        AttackRegistry.registerCipher("variant.autokey", new AutokeyAttack(new AutokeyCipher(VigenereType.VARIANT), "Variant Autokey"), settings);
        AttackRegistry.registerCipher("beaufort.autokey", new AutokeyAttack(new AutokeyCipher(VigenereType.BEAUFORT), "Beaufort Autokey"), settings);
        AttackRegistry.registerCipher("vigenere.nicodemus", new NicodemusAttack(new NicodemusCipher(VigenereType.VIGENERE), "Vigenere Nicodemus"), settings);
        AttackRegistry.registerCipher("porta.nicodemus", new NicodemusAttack(new NicodemusCipher(VigenereType.PORTA), "Porta Nicodemus"), settings);
        AttackRegistry.registerCipher("porta.variant.nicodemus", new NicodemusAttack(new NicodemusCipher(VigenereType.PORTA_VARIANT), "Porta Variant Nicodemus"), settings);
        AttackRegistry.registerCipher("variant.nicodemus", new NicodemusAttack(new NicodemusCipher(VigenereType.VARIANT), "Variant Nicodemus"), settings);
        AttackRegistry.registerCipher("beaufort.nicodemus", new NicodemusAttack(new NicodemusCipher(VigenereType.BEAUFORT), "Beaufort Nicodemus"), settings);
        AttackRegistry.registerCipher("vigenere.slidefair", new SlidefairAttack(new SlidefairCipher(VigenereType.VIGENERE), "Vigenere Slidefair"), settings);
        AttackRegistry.registerCipher("variant.slidefair", new SlidefairAttack(new SlidefairCipher(VigenereType.VARIANT), "Variant Slidefair"), settings);
        AttackRegistry.registerCipher("beaufort.slidefair", new SlidefairAttack(new SlidefairCipher(VigenereType.BEAUFORT), "Beaufort Slidefair"), settings);
        AttackRegistry.registerCipher("solitaire", new SolitaireAttack(), settings);
        AttackRegistry.registerCipher("bifid", new CipherAttack((ICipher)new BifidCipher(), "Bifid").addSetting(new ICipherSettingProvider[]{SettingTypes.createSpinner((String)"period", (Object[])((Integer[])ArrayUtil.concatGeneric((Object[])new Integer[]{0}, (Object[])ArrayUtil.createRangeInteger((int)2, (int)101))), (value, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setSize(value.intValue())))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("bifid.conjugated", new CipherAttack((ICipher)new ConjugatedBifidCipher(), "Conjugated Bifid").addSetting(new ICipherSettingProvider[]{SettingTypes.createSpinner((String)"period", (Object[])((Integer[])ArrayUtil.concatGeneric((Object[])new Integer[]{0}, (Object[])ArrayUtil.createRangeInteger((int)2, (int)101))), (value, cipher) -> cipher.setThirdKeyDomain(builder -> builder.setSize(value.intValue())))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("digrafid", new CipherAttack((ICipher)new DigrafidCipher(), "Digrafid").addSetting(new ICipherSettingProvider[]{SettingTypes.createSpinner((String)"period", (Object[])((Integer[])ArrayUtil.concatGeneric((Object[])new Integer[]{0}, (Object[])ArrayUtil.createRangeInteger((int)2, (int)101))), (value, cipher) -> cipher.setThirdKeyDomain(builder -> builder.setSize(value.intValue())))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("two.square", new CipherAttack((ICipher)new TwoSquareCipher(), "Two Square").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("tri_square", new CipherAttack((ICipher)new TriSquareCipher(), "Tri Square").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("four_square", new CipherAttack((ICipher)new FourSquareCipher(), "Four Square").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("adfgx", new ADFGXAttack(), settings);
        AttackRegistry.registerCipher("cadenus", new CadenusAttack(), settings);
        AttackRegistry.registerCipher("quagmirei", new CipherAttack((ICipher)new QuagmireICipher(), "QuagmireI").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)8, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setRange(values))), SettingTypes.createCombo((String)"indicator_char", (Object[])CharSequenceUtils.toArray((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"), (value, cipher) -> cipher.setThirdKeyDomain(builder -> builder.setUniverse((Object[])new Character[]{value})))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("quagmireii", new CipherAttack((ICipher)new QuagmireIICipher(), "QuagmireIII").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("quagmireiii", new CipherAttack((ICipher)new QuagmireIIICipher(), "QuagmireIII").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("quagmireiv", new CipherAttack((ICipher)new QuagmireIVCipher(), "QuagmireIV").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("enigma", new EnigmaAttack(), settings);
        AttackRegistry.registerCipher("enigma.uhr", new EnigmaUhrAttack(), settings);
        AttackRegistry.registerCipher("enigma.plugboard", new EnigmaPlugboardAttack(), settings);
        AttackRegistry.registerCipher("hill", new HillAttack(), settings);
        AttackRegistry.registerCipher("hill.extended", new HillExtendedAttack(), settings);
        AttackRegistry.registerCipher("hill.subsitution", new HillSubsitutionAttack(), settings);
        AttackRegistry.registerCipher("general_periodic", new GeneralPeriodAttack(), settings);
        AttackRegistry.registerCipher("myszkowski", new CipherAttack((ICipher)new MyszkowskiCipher(), "Myszkowski").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)5, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setDomain(builder -> builder.setRange(values)))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        AttackRegistry.registerCipher("straddle_checkerboard", new StraddleCheckerboardAttack(), settings);
        AttackRegistry.registerCipher("route", new RouteAttack(), settings);
        AttackRegistry.registerCipher("ragbaby", new CipherAttack((ICipher)new RagbabyCipher(), "Ragbaby").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}), settings);
        AttackRegistry.registerCipher("nihilist_substitution", new NihilistSubstitutionAttack(), settings);
        AttackRegistry.registerCipher("nihilist_transposition", new CipherAttack((ICipher)new NihilistTranspositionCipher(), "Nihilist Transposition").addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)10, (int)2, (int)100, (int)1, (values, cipher) -> cipher.setFirstKeyDomain(builder -> builder.setRange(values)))}).addSetting(new ICipherSettingProvider[]{SettingTypes.createCombo((String)"read_mode", (Object[])ReadMode.values(), (value, cipher) -> cipher.setSecondKeyDomain(builder -> builder.setUniverse((Enum[])new ReadMode[]{value})))}).setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE}), settings);
        CIPHERS.freeze();
    }
}

