/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.TriKey;
import com.alexbarter.ciphertool.base.ciphers.TriKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import com.alexbarter.ciphertool.util.VigenereType;
import javax.annotation.Nullable;

public class ProgressiveCipher
extends TriKeyCipher<String, Integer, Integer, VariableStringKeyType.Builder, IntegerKeyType.Builder, IntegerKeyType.Builder> {
    private VigenereType type;

    public ProgressiveCipher(VigenereType typeIn) {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(2, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(1, Integer.MAX_VALUE));
        this.type = typeIn;
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(2, 15);
    }

    public IntegerKeyType.Builder limitDomainForSecondKey(IntegerKeyType.Builder firstKey) {
        return firstKey.setRange(2, 15);
    }

    public IntegerKeyType.Builder limitDomainForThirdKey(IntegerKeyType.Builder firstKey) {
        return firstKey.setRange(1, 15);
    }

    public CharSequence encode(CharSequence plainText, TriKey<String, Integer, Integer> key) {
        String key2 = (String)key.getFirstKey();
        Character[] cipherText = new Character[plainText.length()];
        int progression = 0;
        int count = 0;
        for (int index = 0; index < plainText.length(); ++index) {
            char charIdVig = this.type.encode(plainText.charAt(index), key2.charAt(index % key2.length()));
            cipherText[index] = Character.valueOf(this.type.encode(charIdVig, (char)(progression + 65)));
            if (count + 1 == (Integer)key.getSecondKey()) {
                count = 0;
                progression = (progression + (Integer)key.getThirdKey()) % 26;
                continue;
            }
            ++count;
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, TriKey<String, Integer, Integer> key) {
        String key2 = (String)key.getFirstKey();
        int progression = 0;
        int count = 0;
        for (int index = 0; index < cipherText.length(); ++index) {
            char charIdProg = this.type.decode(cipherText.charAt(index), (char)(progression + 65));
            plainText[index] = this.type.decode(charIdProg, key2.charAt(index % key2.length()));
            if (count + 1 == (Integer)key.getSecondKey()) {
                count = 0;
                progression = (progression + (Integer)key.getThirdKey()) % 26;
                continue;
            }
            ++count;
        }
        return plainText;
    }

    public static char[] decodeBase(char[] cipherText, char[] plainText, int period, int progressiveKey, VigenereType type) {
        int progression = 0;
        int count = 0;
        for (int index = 0; index < cipherText.length; ++index) {
            plainText[index] = type.decode(cipherText[index], (char)(progression + 65));
            if (count + 1 == period) {
                count = 0;
                progression = (progression + progressiveKey) % 26;
                continue;
            }
            ++count;
        }
        return plainText;
    }
}

