/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import tools.cipher.base.interfaces.IKeyType;

public class BooleanKeyType
implements IKeyType<Boolean> {
    private Boolean[] universe;
    private final boolean alterable;

    private BooleanKeyType(Boolean[] universe, boolean alterable) {
        this.universe = universe;
        this.alterable = alterable;
    }

    @Override
    public Boolean randomise() {
        return (Boolean)RandomUtil.pickRandomElement((Object[])this.universe);
    }

    @Override
    public boolean isValid(Boolean key) {
        return ArrayUtil.contains((Object[])this.universe, (Object)key);
    }

    @Override
    public boolean iterateKeys(Function<Boolean, Boolean> consumer) {
        for (Boolean value : this.universe) {
            if (consumer.apply(value).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean alterKey(Boolean key) {
        return this.alterable ? !key.booleanValue() : key;
    }

    @Override
    public BigInteger getNumOfKeys() {
        return BigInteger.valueOf(this.universe.length);
    }

    @Override
    public Boolean parse(String input) throws ParseException {
        if (input.equalsIgnoreCase("true")) {
            return true;
        }
        if (input.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            int i = Integer.parseInt(input);
            if (i == 0) {
                return false;
            }
            if (i == 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ParseException(input, 0);
    }

    @Override
    public String getHelp() {
        StringJoiner joiner = new StringJoiner("|");
        for (Boolean value : this.universe) {
            joiner.add(Boolean.toString(value));
        }
        return joiner.toString();
    }

    @Override
    public String[] getExamples() {
        String[] examples = new String[this.universe.length];
        for (int i = 0; i < this.universe.length; ++i) {
            examples[i] = Boolean.toString(this.universe[i]);
        }
        return examples;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IKeyType.IKeyBuilder<Boolean> {
        private boolean alterable = false;
        private Optional<Boolean[]> universe = Optional.empty();

        private Builder() {
        }

        public Builder setAlterable() {
            this.alterable = true;
            return this;
        }

        public BooleanKeyType create() {
            BooleanKeyType handler = new BooleanKeyType(this.universe.orElse(new Boolean[]{true, false}), this.alterable);
            return handler;
        }

        public Builder setUniverse(Boolean ... universe) {
            this.universe = Optional.of(universe);
            return this;
        }
    }
}

