/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.solve;

import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.util.List;
import tools.cipher.base.interfaces.IAttackMethod;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.settings.SettingsCache;
import tools.cipher.lib.result.Solution;

public interface ISimulatedAnnealingAttack<K>
extends IAttackMethod<K> {
    default public IDecryptionTracker trySimulatedAnnealing(IDecryptionTracker tracker, int iterations) {
        tracker.getProgress().addMax(BigInteger.valueOf((long)Math.floor((Double)((List)SettingsCache.simulatedAnnealing.get()).get(0) / (Double)((List)SettingsCache.simulatedAnnealing.get()).get(1)) + 1L).multiply(BigInteger.valueOf(((Double)((List)SettingsCache.simulatedAnnealing.get()).get(2)).intValue())));
        int ite = 0;
        block0: while (iterations < 0 || ite++ < iterations) {
            this.startIteration(tracker);
            K bestMaximaKey = this.generateIntialKey(tracker);
            Solution bestMaximaSolution = this.toSolution(tracker, bestMaximaKey);
            this.updateIfBetterThanBest(tracker, bestMaximaSolution, bestMaximaKey);
            double TEMP = (Double)((List)SettingsCache.simulatedAnnealing.get()).get(0);
            do {
                TEMP = Math.max(0.0, TEMP - (Double)((List)SettingsCache.simulatedAnnealing.get()).get(1));
                int count = 0;
                while ((double)count < (Double)((List)SettingsCache.simulatedAnnealing.get()).get(2)) {
                    if (tracker.shouldStop()) break block0;
                    this.onPreIteration(tracker);
                    K lastKey = this.modifyKey(tracker, bestMaximaKey, TEMP, count);
                    tracker.setLastSolution(this.toSolution(tracker, lastKey));
                    tracker.addSolution(tracker.getLastSolution());
                    if (this.shouldAcceptSolution(TEMP, tracker.getLastSolution(), bestMaximaSolution)) {
                        bestMaximaSolution = tracker.getLastSolution();
                        bestMaximaKey = lastKey;
                        this.updateIfBetterThanBest(tracker, bestMaximaSolution, bestMaximaKey);
                    }
                    this.onPostIteration(tracker);
                    ++count;
                }
            } while (TEMP > 0.0);
            tracker.getProgress().finish();
            if (this.endIteration(tracker, tracker.getBestSolution())) break;
            this.output(tracker, "============================", new Object[0]);
        }
        return tracker;
    }

    default public K generateIntialKey(IDecryptionTracker tracker) {
        return this.getCipher().randomiseKey(tracker.getLength());
    }

    default public K modifyKey(IDecryptionTracker tracker, K bestMaximaKey, double temp, int count) {
        return this.getCipher().alterKey(bestMaximaKey, temp, count);
    }

    default public boolean shouldAcceptSolution(double TEMP, Solution lastSolution, Solution bestSolution) {
        double lastDF = lastSolution.score - bestSolution.score;
        return lastDF >= 0.0 || TEMP > 0.0 && Math.exp(lastDF / TEMP) > RandomUtil.pickDouble();
    }

    default public void onPreIteration(IDecryptionTracker tracker) {
    }

    default public void onPostIteration(IDecryptionTracker tracker) {
        tracker.getProgress().increment();
    }

    default public void startIteration(IDecryptionTracker tracker) {
        tracker.getProgress().set(0L);
    }

    default public boolean endIteration(IDecryptionTracker tracker, Solution bestSolution) {
        this.output(tracker, bestSolution.toString(), new Object[0]);
        return false;
    }
}

