/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import com.alexbarter.lib.util.MathUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.KeyGeneration;
import tools.cipher.base.key.KeyIterator;
import tools.cipher.base.key.KeyManipulation;
import tools.cipher.lib.characters.CharSequenceUtils;

public class FullStringKeyType
implements IKeyType<String> {
    private final CharSequence alphabet;

    private FullStringKeyType(CharSequence alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public String randomise() {
        return KeyGeneration.createLongKeyUniversal(this.alphabet);
    }

    @Override
    public boolean isValid(String key) {
        try {
            this.parse(key);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean iterateKeys(Function<String, Boolean> consumer) {
        return KeyIterator.permuteString(consumer, this.alphabet);
    }

    @Override
    public String alterKey(String key) {
        return KeyManipulation.swapTwoCharacters(key);
    }

    @Override
    public BigInteger getNumOfKeys() {
        return MathUtil.factorialBig((BigInteger)BigInteger.valueOf(this.alphabet.length()));
    }

    @Override
    public String parse(String input) throws ParseException {
        if ((input = input.toUpperCase(Locale.ROOT)).length() != this.alphabet.length()) {
            throw new ParseException("The key should be of length: " + this.alphabet.length(), 0);
        }
        for (int i = 0; i < this.alphabet.length(); ++i) {
            if (CharSequenceUtils.contains((CharSequence)input, (char)this.alphabet.charAt(i))) continue;
            throw new ParseException("The key should contain the letter: " + this.alphabet.charAt(i), i);
        }
        return input;
    }

    @Override
    public String getHelp() {
        return "key";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IKeyType.IKeyBuilder<String> {
        private Optional<CharSequence> alphabet = Optional.empty();

        private Builder() {
        }

        public Builder setAlphabet(CharSequence alphabet) {
            this.alphabet = Optional.of(alphabet);
            return this;
        }

        public FullStringKeyType create() {
            FullStringKeyType handler = new FullStringKeyType(this.alphabet.orElse("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
            return handler;
        }
    }
}

