/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.ciphers;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nullable;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.base.interfaces.IKeyType;

public abstract class UniKeyCipher<T, A extends IKeyType.IKeyBuilder<T>>
implements ICipher<T> {
    private final IKeyType<T> firstType;
    private IKeyType<T> firstTypeLimit;
    private final A firstKeyBuilder;

    public UniKeyCipher(A firstKey) {
        this.firstType = firstKey.create();
        this.firstTypeLimit = this.limitDomainForFirstKey(firstKey).create();
        this.firstKeyBuilder = firstKey;
    }

    @Override
    public boolean isValid(T key) {
        return this.firstType.isValid(key);
    }

    @Override
    public T randomiseKey() {
        return this.firstTypeLimit.randomise();
    }

    @Override
    public boolean iterateKeys(Function<T, Boolean> consumer) {
        return this.firstTypeLimit.iterateKeys(consumer);
    }

    @Override
    public T alterKey(T key, double temp, int count) {
        return this.firstType.alterKey(key);
    }

    @Override
    public BigInteger getNumOfKeys() {
        return this.firstTypeLimit.getNumOfKeys();
    }

    @Override
    public String prettifyKey(T key) {
        return this.firstType.prettifyKey(key);
    }

    @Override
    public T parseKey(String input) throws ParseException {
        return this.firstType.parse(input);
    }

    @Override
    @Nullable
    public String getHelp() {
        return this.firstType.getHelp();
    }

    public IKeyType.IKeyBuilder<T> limitDomainForFirstKey(A firstKey) {
        return firstKey;
    }

    public void setDomain(Function<A, IKeyType.IKeyBuilder<T>> firstKeyFunc) {
        this.firstTypeLimit = firstKeyFunc.apply(this.firstKeyBuilder).create();
    }

    public IKeyType<T> getDomain() {
        return this.firstTypeLimit;
    }
}

