/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.solve;

import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import tools.cipher.base.interfaces.IAttackMethod;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.solve.DecryptionTracker;
import tools.cipher.lib.language.Dictionary;

public interface IDictionaryAttack<K>
extends IAttackMethod<K> {
    default public IDecryptionTracker tryDictionaryAttack(IDecryptionTracker tracker) {
        Dictionary dictionary = tracker.getLanguage().getDictionary();
        if (dictionary == null) {
            tracker.out().println("NO dictionary for " + tracker.getLanguage().getName());
            return tracker;
        }
        this.output(tracker, "Found %d words", dictionary.wordCount());
        tracker.getProgress().addMax(dictionary.wordCount());
        return tracker;
    }

    public K useWordToGetKey(DecryptionTracker var1, String var2);

    @Nullable
    default public Supplier<Predicate<String>> getWordFilter(DecryptionTracker tracker) {
        return null;
    }
}

