/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.solve;

import java.io.PrintStream;
import java.math.BigInteger;
import tools.cipher.base.interfaces.IAttackMethod;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.settings.SettingsCache;
import tools.cipher.lib.CipherUtils;
import tools.cipher.lib.parallel.MasterThread;

public interface IBruteForceAttack<K>
extends IAttackMethod<K> {
    default public IDecryptionTracker tryBruteForce(IDecryptionTracker tracker) {
        BigInteger totalKeys = this.getCipher().getNumOfKeys();
        this.output(tracker, CipherUtils.formatBigInteger((BigInteger)totalKeys) + " Keys to search", new Object[0]);
        tracker.getProgress().addMax(totalKeys);
        if (((Boolean)SettingsCache.useParallel.get()).booleanValue()) {
            MasterThread thread = new MasterThread(control -> this.getCipher().iterateKeys(key -> {
                Runnable job = () -> {
                    this.decryptAndUpdate(tracker, key);
                    tracker.getProgress().increment();
                };
                return !control.tryAddJob(job, 20L).end();
            })).setErrorHandler(MasterThread.defaultErrorHandler((PrintStream)tracker.out()));
            thread.start();
            thread.waitTillCompleted(tracker::shouldStop);
        } else {
            this.getCipher().iterateKeys(key -> {
                if (tracker.shouldStop()) {
                    return false;
                }
                this.decryptAndUpdate(tracker, key);
                tracker.getProgress().increment();
                return true;
            });
        }
        tracker.getProgress().finish();
        return tracker;
    }
}

