/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.solve;

import com.alexbarter.lib.Pair;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.interfaces.IProgress;
import tools.cipher.base.interfaces.ISettings;
import tools.cipher.base.settings.SettingsCache;
import tools.cipher.lib.fitness.NGramData;
import tools.cipher.lib.fitness.TextFitness;
import tools.cipher.lib.language.ILanguage;
import tools.cipher.lib.result.Solution;

public class DecryptionTracker
implements IDecryptionTracker {
    private final CharSequence cipherText;
    private char[] plainText;
    private final ICipherProgram app;
    private double UPPER_ESTIMATE;
    private Solution bestSolution;
    @Nullable
    private Solution lastSolution;
    public long iteration;
    private Function<Integer, Integer> outputLength = length -> length;
    private List<IDecryptionTracker.ISolutionCallback> callbacks;

    public DecryptionTracker(CharSequence cipherText, ICipherProgram app) {
        this.app = app;
        this.iteration = 1L;
        this.bestSolution = Solution.WORST_SOLUTION;
        this.cipherText = cipherText;
        this.callbacks = new ArrayList<IDecryptionTracker.ISolutionCallback>();
        this.UPPER_ESTIMATE = TextFitness.getEstimatedFitness((int)this.getOutputTextLength(this.cipherText.length()), (NGramData)this.getLanguage().getQuadgramData()) * 1.1;
    }

    public int getOutputTextLength(int inputLength) {
        return this.outputLength.apply(inputLength);
    }

    @Override
    public DecryptionTracker setOutputLength(Function<Integer, Integer> outputLength) {
        this.outputLength = outputLength;
        return this;
    }

    @Override
    public CharSequence getCipherText() {
        return this.cipherText;
    }

    @Override
    public char[] getHolder() {
        if (this.plainText == null) {
            this.plainText = this.getNewHolder();
        }
        return this.plainText;
    }

    @Override
    public char[] getNewHolder() {
        return new char[this.getOutputTextLength(this.getLength())];
    }

    @Override
    public Pair<char[], Boolean> getVariableHolder() {
        return Pair.of((Object)((Boolean)SettingsCache.useParallel.get() != false ? this.getNewHolder() : this.getHolder()), (Object)SettingsCache.useParallel.get());
    }

    @Override
    public boolean addSolution(Solution solutionIn) {
        if (!((Boolean)SettingsCache.collectSolutions.get()).booleanValue() || solutionIn.score <= this.UPPER_ESTIMATE) {
            return false;
        }
        boolean success = false;
        for (IDecryptionTracker.ISolutionCallback c : this.callbacks) {
            success |= c.onSolution(this, solutionIn);
        }
        if (success) {
            solutionIn.bake();
        }
        return success;
    }

    @Override
    public boolean resetSolution() {
        this.bestSolution = Solution.WORST_SOLUTION;
        return true;
    }

    public void resetIteration() {
        this.iteration = 1L;
    }

    @Override
    public Solution getBestSolution() {
        return this.bestSolution;
    }

    @Override
    public Solution getLastSolution() {
        return this.lastSolution;
    }

    @Override
    public IDecryptionTracker setBestSolution(Solution solutionIn) {
        this.bestSolution = solutionIn;
        this.callbacks.forEach(c -> c.onChange(this));
        return this;
    }

    @Override
    public IDecryptionTracker setLastSolution(Solution solutionIn) {
        this.lastSolution = solutionIn;
        return this;
    }

    @Override
    public ICipherProgram getApp() {
        return this.app;
    }

    @Override
    public ILanguage getLanguage() {
        return this.app.getLanguage();
    }

    public ISettings getSettings() {
        return this.app.getSettings();
    }

    @Override
    public IProgress getProgress() {
        return this.app.getProgress();
    }

    @Override
    public PrintStream out() {
        return this.app.out();
    }

    @Override
    public boolean shouldStop() {
        return this.app.shouldStop();
    }

    @Override
    public void addCallback(IDecryptionTracker.ISolutionCallback callback) {
        this.callbacks.add(callback);
    }
}

