/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.IRangedKeyType;
import tools.cipher.base.key.KeyGeneration;
import tools.cipher.base.key.KeyIterator;

public class GrilleKeyType
implements IKeyType<Integer[]> {
    private final int min;
    private final int max;

    private GrilleKeyType(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public Integer[] randomise() {
        return KeyGeneration.createGrilleKey(RandomUtil.pickRandomInt((int)this.min, (int)this.max));
    }

    @Override
    public boolean isValid(Integer[] key) {
        return true;
    }

    @Override
    public boolean iterateKeys(Function<Integer[], Boolean> consumer) {
        for (int size = this.min; size <= this.max; ++size) {
            if (KeyIterator.iterateGrille(consumer, size)) continue;
            return false;
        }
        return false;
    }

    @Override
    public BigInteger getNumOfKeys() {
        return BigInteger.valueOf(59049L);
    }

    @Override
    public Integer[] alterKey(Integer[] key) {
        return key;
    }

    @Override
    public String prettifyKey(Integer[] key) {
        return Arrays.toString((Object[])key);
    }

    @Override
    public Integer[] parse(String input) throws ParseException {
        throw new UnsupportedOperationException();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IRangedKeyType.IRangedKeyBuilder<Integer[]> {
        private Optional<Integer> min = Optional.empty();
        private Optional<Integer> max = Optional.empty();

        private Builder() {
        }

        public Builder setMin(int min) {
            this.min = Optional.of(min);
            return this;
        }

        public Builder setMax(int max) {
            this.max = Optional.of(max);
            return this;
        }

        public Builder setRange(int min, int max) {
            return this.setMin(min).setMax(max);
        }

        public Builder setSize(int size) {
            return this.setRange(size, size);
        }

        public GrilleKeyType create() {
            GrilleKeyType handler = new GrilleKeyType(this.min.orElse(2), this.max.orElse(6));
            return handler;
        }
    }
}

