/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.interfaces;

import com.alexbarter.lib.Pair;
import java.io.PrintStream;
import java.util.function.Function;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IProgress;
import tools.cipher.base.solve.DecryptionTracker;
import tools.cipher.lib.language.ILanguage;
import tools.cipher.lib.result.Solution;

public interface IDecryptionTracker {
    public CharSequence getCipherText();

    default public int getLength() {
        return this.getCipherText().length();
    }

    public Solution getBestSolution();

    public Solution getLastSolution();

    public IDecryptionTracker setBestSolution(Solution var1);

    public IDecryptionTracker setLastSolution(Solution var1);

    public boolean addSolution(Solution var1);

    public boolean resetSolution();

    public boolean shouldStop();

    public DecryptionTracker setOutputLength(Function<Integer, Integer> var1);

    public IProgress getProgress();

    public ILanguage getLanguage();

    public char[] getNewHolder();

    public char[] getHolder();

    public Pair<char[], Boolean> getVariableHolder();

    public ICipherProgram getApp();

    public PrintStream out();

    public void addCallback(ISolutionCallback var1);

    @FunctionalInterface
    public static interface ISolutionCallback {
        public void onChange(IDecryptionTracker var1);

        default public boolean onSolution(DecryptionTracker tracker, Solution solutionIn) {
            return false;
        }
    }
}

