/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.interfaces;

import com.alexbarter.lib.Pair;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.lib.result.Result;
import tools.cipher.lib.result.Solution;

public interface IAttackMethod<K> {
    public ICipher<K> getCipher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decryptAndUpdate(IDecryptionTracker tracker, K key) {
        Solution solution = this.toSolution(tracker, key);
        IDecryptionTracker iDecryptionTracker = tracker;
        synchronized (iDecryptionTracker) {
            this.updateIfBetterThanBest(tracker, solution, key);
        }
    }

    default public Solution toSolution(IDecryptionTracker tracker, K key) {
        Pair<char[], Boolean> holder = tracker.getVariableHolder();
        return new Solution(this.getCipher().decodeEfficiently(tracker.getCipherText(), (char[])holder.getLeft(), key), tracker.getLanguage(), ((Boolean)holder.getRight()).booleanValue());
    }

    default public boolean updateIfBetterThanBest(IDecryptionTracker tracker, Solution solution) {
        return this.updateIfBetterThanBest(tracker, solution, (K)null);
    }

    default public boolean updateIfBetterThanBest(IDecryptionTracker tracker, Solution solution, K key) {
        if (this.isBetterThanBest(tracker, solution)) {
            this.updateBestSolution(tracker, solution, key);
            return true;
        }
        return false;
    }

    default public boolean updateIfBetterThanBest(IDecryptionTracker tracker, Solution solution, Supplier<K> key) {
        if (this.isBetterThanBest(tracker, solution)) {
            this.updateBestSolution(tracker, solution, key.get());
            return true;
        }
        return false;
    }

    default public boolean isBetterThanBest(IDecryptionTracker tracker, Solution solution) {
        return solution.compareTo((Result)tracker.getBestSolution()) < 0;
    }

    default public void updateBestSolution(IDecryptionTracker tracker, Solution solution, @Nullable K key) {
        solution.bake();
        if (key != null) {
            solution.setKeyString(this.getCipher().prettifyKey(key));
        }
        this.output(tracker, solution.toString(), new Object[0]);
        tracker.setBestSolution(solution);
    }

    default public boolean isMuted() {
        return false;
    }

    default public boolean output(IDecryptionTracker tracker, String text, Object ... format) {
        if (!this.isMuted() && !tracker.shouldStop()) {
            tracker.out().println(format.length > 0 ? String.format(text, format) : text);
            return true;
        }
        return false;
    }
}

