/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.format;

import java.text.ParseException;
import tools.cipher.base.format.IParseFormat;
import tools.cipher.base.interfaces.IFormat;

public class BlockFormat
implements IFormat {
    private final int size;
    private final CharSequence join;
    public static final IParseFormat PARSE = (text, args) -> {
        int size = 0;
        try {
            size = Integer.parseInt(args);
        }
        catch (NumberFormatException e) {
            throw new ParseException(args, 0);
        }
        return new BlockFormat(size);
    };

    public BlockFormat(int sizeIn, CharSequence joinIn) {
        if (sizeIn < 0) {
            throw new IllegalArgumentException();
        }
        this.size = sizeIn;
        this.join = joinIn;
    }

    public BlockFormat(int sizeIn) {
        this(sizeIn, " ");
    }

    @Override
    public CharSequence format(CharSequence text) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ') continue;
            if (this.size > 0 && count % this.size == 0 && count > 0) {
                builder.append(this.join);
            }
            builder.append(ch);
            ++count;
        }
        return builder;
    }
}

