/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.ciphers;

import java.util.Objects;

public final class BiKey<F, S>
implements Cloneable {
    private F firstKey;
    private S secondKey;

    public BiKey(F firstKey, S secondKey) {
        this.firstKey = firstKey;
        this.secondKey = secondKey;
    }

    public BiKey<F, S> setFirst(F first) {
        this.firstKey = first;
        return this;
    }

    public BiKey<F, S> setSecond(S second) {
        this.secondKey = second;
        return this;
    }

    public F getFirstKey() {
        return this.firstKey;
    }

    public S getSecondKey() {
        return this.secondKey;
    }

    public static <F, S> BiKey<F, S> empty() {
        return new BiKey<Object, Object>(null, null);
    }

    public static <F, S> BiKey<F, S> of(F first, S second) {
        return new BiKey<F, S>(first, second);
    }

    public BiKey<F, S> clone() {
        return new BiKey<F, S>(this.firstKey, this.secondKey);
    }

    public int hashCode() {
        return Objects.hash(this.firstKey, this.secondKey);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BiKey)) {
            return false;
        }
        BiKey other = (BiKey)obj;
        return Objects.equals(this.firstKey, other.firstKey) && Objects.equals(this.secondKey, other.secondKey);
    }
}

