/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.interfaces;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface IKeyType<K> {
    public K randomise();

    public boolean iterateKeys(Function<K, Boolean> var1);

    public K alterKey(K var1);

    public boolean isValid(K var1);

    @Nullable
    public BigInteger getNumOfKeys();

    default public K inverseKey(K key) {
        return key;
    }

    default public String prettifyKey(K key) {
        return key.toString();
    }

    default public K parse(String input) throws ParseException {
        throw new UnsupportedOperationException();
    }

    default public String getHelp() {
        return this.getClass().getSimpleName();
    }

    default public String[] getExamples() {
        throw new UnsupportedOperationException();
    }

    public static interface IKeyBuilder<K> {
        public IKeyType<K> create();

        default public IKeyBuilder<K> setDisplay(Function<K, String> displayFunc) {
            throw new UnsupportedOperationException();
        }
    }
}

